/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Timer;

public class ThreadUtils {
    private static boolean java13 = false;
    private static boolean java14 = false;

    public static Timer createTimer(String name) {
        try {
            Constructor c2 = Timer.class.getConstructor(String.class);
            return (Timer)c2.newInstance(name);
        }
        catch (Throwable e2) {
            return new Timer();
        }
    }

    public static String getCallLocation(String fqn) {
        if (!java13) {
            try {
                StackTraceElement[] ste = new Throwable().getStackTrace();
                int i2 = 0;
                while (i2 < ste.length - 1) {
                    StackTraceElement callLocation;
                    String nextClassName;
                    if (fqn.equals(ste[i2].getClassName()) && !(nextClassName = (callLocation = ste[i2 + 1]).getClassName()).equals(fqn)) {
                        return callLocation.toString();
                    }
                    ++i2;
                }
            }
            catch (Throwable e2) {
                java13 = true;
            }
        }
        return null;
    }

    public static String getTreadStackTrace(Thread t2) {
        if (java14) {
            return "";
        }
        try {
            Method m2 = t2.getClass().getMethod("getStackTrace", null);
            StackTraceElement[] trace = (StackTraceElement[])m2.invoke((Object)t2, null);
            StringBuffer b2 = new StringBuffer();
            int i2 = 0;
            while (i2 < trace.length) {
                b2.append("\n\tat ").append(trace[i2]);
                ++i2;
            }
            return b2.toString();
        }
        catch (Throwable e2) {
            java14 = true;
            return "";
        }
    }
}

