/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.microedition.io;

import com.sun.cdc.io.ConnectionBaseInterface;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Vector;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import org.microemu.cldc.ClosedConnection;
import org.microemu.log.Logger;
import org.microemu.microedition.io.ConnectionImplementation;
import org.microemu.microedition.io.ConnectionInvocationHandler;
import org.microemu.microedition.io.ConnectorAdapter;

public class ConnectorImpl
extends ConnectorAdapter {
    private AccessControlContext acc;
    public static boolean debugConnectionInvocations = false;
    private final boolean needPrivilegedCalls = ConnectorImpl.isWebstart();

    public ConnectorImpl() {
        this.acc = AccessController.getContext();
    }

    private static boolean isWebstart() {
        try {
            return System.getProperty("javawebstart.version") != null;
        }
        catch (SecurityException e2) {
            return false;
        }
    }

    @Override
    public Connection open(final String name, final int mode, final boolean timeouts) throws IOException {
        try {
            return (Connection)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    if (debugConnectionInvocations || ConnectorImpl.this.needPrivilegedCalls) {
                        return ConnectorImpl.this.openSecureProxy(name, mode, timeouts, ConnectorImpl.this.needPrivilegedCalls);
                    }
                    return ConnectorImpl.this.openSecure(name, mode, timeouts);
                }
            }, this.acc);
        }
        catch (PrivilegedActionException e2) {
            if (e2.getCause() instanceof IOException) {
                throw (IOException)e2.getCause();
            }
            throw new IOException(e2.toString());
        }
    }

    private static Class[] getAllInterfaces(Class klass) {
        Vector allInterfaces = new Vector();
        Class parent = klass;
        while (parent != null) {
            Class<?>[] interfaces = parent.getInterfaces();
            int i2 = 0;
            while (i2 < interfaces.length) {
                allInterfaces.add(interfaces[i2]);
                ++i2;
            }
            parent = parent.getSuperclass();
        }
        return allInterfaces.toArray(new Class[allInterfaces.size()]);
    }

    private Connection openSecureProxy(String name, int mode, boolean timeouts, boolean needPrivilegedCalls) throws IOException {
        Connection origConnection = this.openSecure(name, mode, timeouts);
        Class connectionClass = null;
        Class[] interfaces = ConnectorImpl.getAllInterfaces(origConnection.getClass());
        int i2 = 0;
        while (i2 < interfaces.length) {
            if (Connection.class.isAssignableFrom(interfaces[i2])) {
                connectionClass = interfaces[i2];
                break;
            }
            if (interfaces[i2].getClass().getName().equals(Connection.class.getName())) {
                Logger.debugClassLoader("ME2 Connection.class", Connection.class);
                Logger.debugClassLoader(String.valueOf(name) + " Connection.class", interfaces[i2]);
                Logger.error("Connection interface loaded by different ClassLoader");
            }
            ++i2;
        }
        if (connectionClass == null) {
            throw new ClassCastException(String.valueOf(origConnection.getClass().getName()) + " Connection expected");
        }
        return (Connection)Proxy.newProxyInstance(ConnectorImpl.class.getClassLoader(), interfaces, (InvocationHandler)new ConnectionInvocationHandler(origConnection, needPrivilegedCalls));
    }

    private Connection openSecure(String name, int mode, boolean timeouts) throws IOException {
        String className = null;
        String protocol = null;
        try {
            try {
                protocol = name.substring(0, name.indexOf(58));
                className = "org.microemu.cldc." + protocol + ".Connection";
                Class<?> cl = Class.forName(className);
                Object inst = cl.newInstance();
                if (inst instanceof ConnectionImplementation) {
                    return ((ConnectionImplementation)inst).openConnection(name, mode, timeouts);
                }
                return ((ClosedConnection)inst).open(name);
            }
            catch (ClassNotFoundException e2) {
                try {
                    className = "com.sun.cdc.io.j2me." + protocol + ".Protocol";
                    Class<?> cl = Class.forName(className);
                    ConnectionBaseInterface base = (ConnectionBaseInterface)cl.newInstance();
                    return base.openPrim(name.substring(name.indexOf(58) + 1), mode, timeouts);
                }
                catch (ClassNotFoundException ex) {
                    Logger.debug("connection [" + protocol + "] class not found", e2);
                    Logger.debug("connection [" + protocol + "] class not found", ex);
                    throw new ConnectionNotFoundException("connection [" + protocol + "] class not found");
                }
            }
        }
        catch (InstantiationException e3) {
            Logger.error("Unable to create", className, e3);
            throw new ConnectionNotFoundException();
        }
        catch (IllegalAccessException e4) {
            Logger.error("Unable to create", className, e4);
            throw new ConnectionNotFoundException();
        }
    }
}

