/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.device.swt;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import org.eclipse.swt.graphics.RGB;
import org.microemu.app.ui.swt.SwtGraphics;
import org.microemu.device.Device;
import org.microemu.device.DeviceFactory;
import org.microemu.device.impl.Rectangle;
import org.microemu.device.impl.Shape;
import org.microemu.device.impl.SoftButton;
import org.microemu.device.swt.SwtButton;
import org.microemu.device.swt.SwtDeviceDisplay;
import org.microemu.device.swt.SwtFont;
import org.microemu.device.swt.SwtFontManager;
import org.microemu.device.swt.SwtImmutableImage;

public class SwtSoftButton
extends SwtButton
implements SoftButton {
    public static int LEFT = 1;
    public static int RIGHT = 2;
    private int type;
    private Image normalImage;
    private Image pressedImage;
    private Vector commandTypes = new Vector();
    private Command command = null;
    private Rectangle paintable;
    private int alignment;
    private boolean visible;
    private boolean pressed;
    private Font font;

    public SwtSoftButton(String name, Shape shape, int keyCode, String keyName, Rectangle paintable, String alignmentName, Vector commands, Font font) {
        super(name, shape, keyCode, keyName, new Hashtable());
        this.type = 1;
        this.paintable = paintable;
        this.visible = true;
        this.pressed = false;
        this.font = font;
        if (alignmentName != null) {
            try {
                this.alignment = SwtSoftButton.class.getField(alignmentName).getInt(null);
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
        Enumeration e2 = commands.elements();
        while (e2.hasMoreElements()) {
            String tmp = (String)e2.nextElement();
            try {
                this.addCommandType(Command.class.getField(tmp).getInt(null));
            }
            catch (Exception ex) {
                System.err.println("a3" + ex);
            }
        }
    }

    public SwtSoftButton(String name, Rectangle paintable, Image normalImage, Image pressedImage) {
        super(name, null, Integer.MIN_VALUE, null, null);
        this.type = 2;
        this.paintable = paintable;
        this.normalImage = normalImage;
        this.pressedImage = pressedImage;
        this.visible = true;
        this.pressed = false;
    }

    @Override
    public int getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCommand(Command cmd) {
        SwtSoftButton swtSoftButton = this;
        synchronized (swtSoftButton) {
            this.command = cmd;
        }
    }

    @Override
    public Command getCommand() {
        return this.command;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean state) {
        this.visible = state;
    }

    @Override
    public boolean isPressed() {
        return this.pressed;
    }

    @Override
    public void setPressed(boolean state) {
        this.pressed = state;
    }

    @Override
    public Rectangle getPaintable() {
        return this.paintable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(SwtGraphics g2) {
        if (!this.visible || this.paintable == null) {
            return;
        }
        org.eclipse.swt.graphics.Rectangle clip = g2.getClipping();
        g2.setClipping(this.paintable.x, this.paintable.y, this.paintable.width, this.paintable.height);
        if (this.type == 1) {
            int xoffset = 0;
            Device device = DeviceFactory.getDevice();
            SwtDeviceDisplay deviceDisplay = (SwtDeviceDisplay)device.getDeviceDisplay();
            if (this.pressed) {
                g2.setForeground(g2.getColor(new RGB(deviceDisplay.getForegroundColor().getRed(), deviceDisplay.getForegroundColor().getGreen(), deviceDisplay.getForegroundColor().getBlue())));
            } else {
                g2.setBackground(g2.getColor(new RGB(deviceDisplay.getBackgroundColor().getRed(), deviceDisplay.getBackgroundColor().getGreen(), deviceDisplay.getBackgroundColor().getBlue())));
            }
            g2.fillRectangle(this.paintable.x, this.paintable.y, this.paintable.width, this.paintable.height);
            SwtSoftButton swtSoftButton = this;
            synchronized (swtSoftButton) {
                if (this.command != null) {
                    if (this.font != null) {
                        SwtFontManager fontManager = (SwtFontManager)device.getFontManager();
                        SwtFont buttonFont = (SwtFont)fontManager.getFont(this.font);
                        g2.setFont(buttonFont.getFont());
                    }
                    if (this.alignment == RIGHT) {
                        xoffset = this.paintable.width - g2.stringWidth(this.command.getLabel());
                    }
                    if (this.pressed) {
                        g2.setBackground(g2.getColor(new RGB(deviceDisplay.getBackgroundColor().getRed(), deviceDisplay.getBackgroundColor().getGreen(), deviceDisplay.getBackgroundColor().getBlue())));
                    } else {
                        g2.setForeground(g2.getColor(new RGB(deviceDisplay.getForegroundColor().getRed(), deviceDisplay.getForegroundColor().getGreen(), deviceDisplay.getForegroundColor().getBlue())));
                    }
                    g2.drawString(this.command.getLabel(), this.paintable.x + xoffset, this.paintable.y + (this.paintable.height - g2.getFontMetrics().getHeight()), true);
                }
            }
        } else if (this.type == 2) {
            if (this.pressed) {
                g2.drawImage(((SwtImmutableImage)this.pressedImage).getImage(), this.paintable.x, this.paintable.y);
            } else {
                g2.drawImage(((SwtImmutableImage)this.normalImage).getImage(), this.paintable.x, this.paintable.y);
            }
        }
        g2.setClipping(clip);
    }

    @Override
    public boolean preferredCommandType(Command cmd) {
        Enumeration ct = this.commandTypes.elements();
        while (ct.hasMoreElements()) {
            if (cmd.getCommandType() != ((Integer)ct.nextElement()).intValue()) continue;
            return true;
        }
        return false;
    }

    public void addCommandType(int commandType) {
        this.commandTypes.addElement(new Integer(commandType));
    }
}

