/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.device.swt;

import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Command;
import org.eclipse.swt.events.KeyEvent;
import org.microemu.DisplayAccess;
import org.microemu.MIDletAccess;
import org.microemu.MIDletBridge;
import org.microemu.device.DeviceFactory;
import org.microemu.device.InputMethodEvent;
import org.microemu.device.impl.InputMethodImpl;
import org.microemu.device.impl.SoftButton;
import org.microemu.device.impl.ui.CommandManager;
import org.microemu.device.swt.SwtButton;

public class SwtInputMethod
extends InputMethodImpl {
    private Timer keyRepeatTimer = new Timer();
    private int repeatModeKeyCode = Integer.MIN_VALUE;
    private boolean clearRepeatFlag = false;

    @Override
    public int getGameAction(int keyCode) {
        switch (keyCode) {
            case 0x1000001: {
                return 1;
            }
            case 0x1000002: {
                return 6;
            }
            case 0x1000003: {
                return 2;
            }
            case 0x1000004: {
                return 5;
            }
            case 13: {
                return 8;
            }
        }
        return 0;
    }

    @Override
    public int getKeyCode(int gameAction) {
        switch (gameAction) {
            case 1: {
                return 0x1000001;
            }
            case 6: {
                return 0x1000002;
            }
            case 2: {
                return 0x1000003;
            }
            case 5: {
                return 0x1000004;
            }
            case 8: {
                return 13;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String getKeyName(int keyCode) throws IllegalArgumentException {
        for (SwtButton button : DeviceFactory.getDevice().getButtons()) {
            if (button.getKeyCode() != keyCode) continue;
            return button.getName();
        }
        for (SwtButton button : DeviceFactory.getDevice().getButtons()) {
            if (button.getKeyboardKey() != keyCode) continue;
            return button.getName();
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean commonKeyPressed(KeyEvent ev) {
        int keyCode = ev.keyCode;
        if (this.inputMethodListener == null) {
            switch (ev.keyCode) {
                case 8: {
                    return true;
                }
            }
            int midpKeyCode = keyCode;
            switch (ev.character) {
                case '*': {
                    midpKeyCode = 42;
                    break;
                }
                case '#': {
                    midpKeyCode = 35;
                    break;
                }
                default: {
                    midpKeyCode = keyCode;
                }
            }
            MIDletBridge.getMIDletAccess().getDisplayAccess().keyPressed(midpKeyCode);
            return true;
        }
        if (this.getGameAction(keyCode) == 1 || this.getGameAction(keyCode) == 6) {
            MIDletBridge.getMIDletAccess().getDisplayAccess().keyPressed(keyCode);
            return true;
        }
        int caret = this.inputMethodListener.getCaretPosition();
        if (this.getGameAction(keyCode) == 2 || this.getGameAction(keyCode) == 5) {
            SwtInputMethod swtInputMethod = this;
            synchronized (swtInputMethod) {
                if (this.getGameAction(keyCode) == 2 && caret > 0) {
                    --caret;
                }
                if (this.getGameAction(keyCode) == 5 && caret < this.inputMethodListener.getText().length()) {
                    ++caret;
                }
                this.lastButton = null;
                this.lastButtonCharIndex = -1;
            }
            InputMethodEvent event = new InputMethodEvent(1, caret, this.inputMethodListener.getText());
            this.inputMethodListener.caretPositionChanged(event);
            return true;
        }
        if (keyCode == 8) {
            String tmp = this.inputMethodListener.getText();
            SwtInputMethod swtInputMethod = this;
            synchronized (swtInputMethod) {
                if (this.lastButton != null) {
                    ++caret;
                    this.lastButton = null;
                    this.lastButtonCharIndex = -1;
                }
                if (caret > 0) {
                    tmp = "";
                    if (--caret > 0) {
                        tmp = String.valueOf(tmp) + this.inputMethodListener.getText().substring(0, caret);
                    }
                    if (caret < this.inputMethodListener.getText().length() - 1) {
                        tmp = String.valueOf(tmp) + this.inputMethodListener.getText().substring(caret + 1);
                    }
                }
            }
            if (!SwtInputMethod.validate(tmp, this.inputMethodListener.getConstraints())) {
                return true;
            }
            InputMethodEvent event = new InputMethodEvent(2, caret, tmp);
            this.inputMethodListener.inputMethodTextChanged(event);
            event = new InputMethodEvent(1, caret, tmp);
            this.inputMethodListener.caretPositionChanged(event);
            return true;
        }
        if (keyCode == 127) {
            String tmp = this.inputMethodListener.getText();
            Object event = this;
            synchronized (event) {
                if (this.lastButton != null) {
                    this.lastButton = null;
                    this.lastButtonCharIndex = -1;
                }
                if (caret != this.inputMethodListener.getText().length()) {
                    tmp = String.valueOf(this.inputMethodListener.getText().substring(0, caret)) + this.inputMethodListener.getText().substring(caret + 1);
                }
            }
            if (!SwtInputMethod.validate(tmp, this.inputMethodListener.getConstraints())) {
                return true;
            }
            event = new InputMethodEvent(2, caret, tmp);
            this.inputMethodListener.inputMethodTextChanged((InputMethodEvent)event);
            event = new InputMethodEvent(1, caret, tmp);
            this.inputMethodListener.caretPositionChanged((InputMethodEvent)event);
            return true;
        }
        return keyCode == 131072 || keyCode == 262144 || keyCode == 65536;
    }

    public void keyPressed(KeyEvent ev) {
        Command cmd;
        if (DeviceFactory.getDevice().hasRepeatEvents() && this.inputMethodListener == null) {
            this.clearRepeatFlag = false;
            if (this.repeatModeKeyCode == ev.keyCode) {
                MIDletAccess ma = MIDletBridge.getMIDletAccess();
                if (ma == null) {
                    return;
                }
                DisplayAccess da = ma.getDisplayAccess();
                if (da == null) {
                    return;
                }
                da.keyRepeated(ev.keyCode);
                return;
            }
            this.repeatModeKeyCode = ev.keyCode;
        }
        boolean rawSoftKeys = DeviceFactory.getDevice().getDeviceDisplay().isFullScreenMode();
        SwtButton pressedButton = this.getButton(ev);
        if (pressedButton != null && pressedButton instanceof SoftButton && !rawSoftKeys && (cmd = ((SoftButton)((Object)pressedButton)).getCommand()) != null) {
            MIDletAccess ma = MIDletBridge.getMIDletAccess();
            if (ma == null) {
                return;
            }
            DisplayAccess da = ma.getDisplayAccess();
            if (da == null) {
                return;
            }
            if (cmd.equals(CommandManager.CMD_MENU)) {
                CommandManager.getInstance().commandAction(cmd);
            } else {
                da.commandAction(cmd, da.getCurrent());
            }
            return;
        }
        if (this.commonKeyPressed(ev)) {
            return;
        }
        if (this.inputMethodListener.getText().length() < this.maxSize && (ev.keyCode & 0x1000000) == 0) {
            this.insertText(new Character(ev.character).toString());
        }
    }

    public void keyReleased(KeyEvent ev) {
        if (DeviceFactory.getDevice().hasRepeatEvents() && this.inputMethodListener == null) {
            this.clearRepeatFlag = true;
            this.keyRepeatTimer.schedule((TimerTask)new KeyRepeatTask(), 50L);
        } else {
            MIDletAccess ma = MIDletBridge.getMIDletAccess();
            if (ma == null) {
                return;
            }
            DisplayAccess da = ma.getDisplayAccess();
            if (da == null) {
                return;
            }
            da.keyReleased(ev.keyCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mousePressed(KeyEvent ev) {
        if (this.commonKeyPressed(ev)) {
            return;
        }
        if (this.inputMethodListener.getText().length() < this.maxSize) {
            Enumeration e2 = DeviceFactory.getDevice().getButtons().elements();
            while (e2.hasMoreElements()) {
                SwtButton button = (SwtButton)e2.nextElement();
                if (ev.keyCode != button.getKeyCode()) continue;
                int caret = this.inputMethodListener.getCaretPosition();
                String tmp = this.inputMethodListener.getText();
                SwtInputMethod swtInputMethod = this;
                synchronized (swtInputMethod) {
                    ++this.lastButtonCharIndex;
                    char[] buttonChars = this.filterConstraints(this.filterInputMode(button.getChars(this.getInputMode())));
                    if (buttonChars.length > 0) {
                        if (this.lastButtonCharIndex == buttonChars.length) {
                            if (buttonChars.length == 1) {
                                if (this.lastButton != null) {
                                    ++caret;
                                }
                                this.lastButton = null;
                            } else {
                                this.lastButtonCharIndex = 0;
                            }
                        }
                        if (this.lastButton != button) {
                            if (this.lastButton != null) {
                                ++caret;
                            }
                            tmp = "";
                            if (caret > 0) {
                                tmp = String.valueOf(tmp) + this.inputMethodListener.getText().substring(0, caret);
                            }
                            tmp = String.valueOf(tmp) + buttonChars[0];
                            if (caret < this.inputMethodListener.getText().length()) {
                                tmp = String.valueOf(tmp) + this.inputMethodListener.getText().substring(caret);
                            }
                            this.lastButton = button;
                            this.lastButtonCharIndex = 0;
                        } else {
                            tmp = "";
                            if (caret > 0) {
                                tmp = String.valueOf(tmp) + this.inputMethodListener.getText().substring(0, caret);
                            }
                            tmp = String.valueOf(tmp) + buttonChars[this.lastButtonCharIndex];
                            if (caret < this.inputMethodListener.getText().length() - 1) {
                                tmp = String.valueOf(tmp) + this.inputMethodListener.getText().substring(caret + 1);
                            }
                            this.lastButton = button;
                        }
                    } else {
                        this.lastButton = null;
                        this.lastButtonCharIndex = -1;
                    }
                    this.resetKey = false;
                    this.notify();
                }
                if (!SwtInputMethod.validate(tmp, this.inputMethodListener.getConstraints())) {
                    return;
                }
                InputMethodEvent event = new InputMethodEvent(2, caret, tmp);
                this.inputMethodListener.inputMethodTextChanged(event);
                break;
            }
        }
    }

    public void mouseReleased(int keyCode) {
        MIDletAccess ma = MIDletBridge.getMIDletAccess();
        if (ma == null) {
            return;
        }
        DisplayAccess da = ma.getDisplayAccess();
        if (da == null) {
            return;
        }
        da.keyReleased(keyCode);
    }

    public SwtButton getButton(KeyEvent ev) {
        Enumeration e2 = DeviceFactory.getDevice().getButtons().elements();
        while (e2.hasMoreElements()) {
            SwtButton button = (SwtButton)e2.nextElement();
            if (ev.keyCode == button.getKeyCode()) {
                return button;
            }
            if (!button.isChar(ev.character, this.getInputMode())) continue;
            return button;
        }
        return null;
    }

    private class KeyRepeatTask
    extends TimerTask {
        private KeyRepeatTask() {
        }

        @Override
        public void run() {
            if (SwtInputMethod.this.repeatModeKeyCode != Integer.MIN_VALUE) {
                MIDletAccess ma = MIDletBridge.getMIDletAccess();
                if (ma == null) {
                    return;
                }
                DisplayAccess da = ma.getDisplayAccess();
                if (da == null) {
                    return;
                }
                if (SwtInputMethod.this.clearRepeatFlag) {
                    da.keyReleased(SwtInputMethod.this.repeatModeKeyCode);
                    SwtInputMethod.this.repeatModeKeyCode = Integer.MIN_VALUE;
                }
            }
        }
    }
}

