/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.device.swt;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.microemu.app.ui.swt.SwtDeviceComponent;
import org.microemu.device.swt.SwtMutableImage;

public class SwtImmutableImage
extends javax.microedition.lcdui.Image {
    Image img;

    public SwtImmutableImage(Image image) {
        this.img = image;
    }

    public SwtImmutableImage(SwtMutableImage image) {
        this.img = SwtDeviceComponent.createImage(image.getImage());
    }

    @Override
    public int getHeight() {
        return this.img.getBounds().height;
    }

    public Image getImage() {
        return this.img;
    }

    @Override
    public int getWidth() {
        return this.img.getBounds().width;
    }

    @Override
    public void getRGB(int[] argb, int offset, int scanlength, int x2, int y2, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (x2 < 0 || y2 < 0 || x2 + width > this.getWidth() || y2 + height > this.getHeight()) {
            throw new IllegalArgumentException("Specified area exceeds bounds of image");
        }
        if ((scanlength < 0 ? -scanlength : scanlength) < width) {
            throw new IllegalArgumentException("abs value of scanlength is less than width");
        }
        if (argb == null) {
            throw new NullPointerException("null rgbData");
        }
        if (offset < 0 || offset + width > argb.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (scanlength < 0 ? offset + scanlength * (height - 1) < 0 : offset + scanlength * (height - 1) + width > argb.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ImageData imageData = this.img.getImageData();
        int i2 = 0;
        while (i2 < height) {
            imageData.getPixels(x2, y2 + i2, width, argb, offset + i2 * scanlength);
            ++i2;
        }
    }
}

