/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.device.swt;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.microemu.DisplayAccess;
import org.microemu.MIDletBridge;
import org.microemu.app.ui.swt.ImageFilter;
import org.microemu.app.ui.swt.SwtGraphics;
import org.microemu.device.Device;
import org.microemu.device.DeviceFactory;
import org.microemu.device.DisplayGraphics;
import org.microemu.device.MutableImage;
import org.microemu.device.swt.BWImageFilter;
import org.microemu.device.swt.GrayImageFilter;
import org.microemu.device.swt.RGBImageFilter;
import org.microemu.device.swt.SwtDeviceDisplay;
import org.microemu.device.swt.SwtFont;
import org.microemu.device.swt.SwtFontManager;
import org.microemu.device.swt.SwtImmutableImage;
import org.microemu.device.swt.SwtMutableImage;

public class SwtDisplayGraphics
extends Graphics
implements DisplayGraphics {
    public SwtGraphics g;
    private MutableImage image;
    private int color = 0;
    private Font currentFont = Font.getDefaultFont();
    private ImageFilter filter;

    public SwtDisplayGraphics(SwtGraphics a_g, MutableImage a_image) {
        this.g = a_g;
        this.image = a_image;
        Device device = DeviceFactory.getDevice();
        this.g.setBackground(this.g.getColor(new RGB(((SwtDeviceDisplay)device.getDeviceDisplay()).getBackgroundColor().getRed(), ((SwtDeviceDisplay)device.getDeviceDisplay()).getBackgroundColor().getGreen(), ((SwtDeviceDisplay)device.getDeviceDisplay()).getBackgroundColor().getBlue())));
        SwtFont tmpFont = (SwtFont)((SwtFontManager)device.getFontManager()).getFont(this.currentFont);
        this.g.setFont(tmpFont.getFont());
        this.filter = device.getDeviceDisplay().isColor() ? new RGBImageFilter() : (device.getDeviceDisplay().numColors() == 2 ? new BWImageFilter() : new GrayImageFilter());
    }

    @Override
    public MutableImage getImage() {
        return this.image;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setColor(int RGB2) {
        this.color = RGB2;
        this.g.setForeground(this.g.getColor(this.filter.filterRGB(0, 0, new RGB(this.color >> 16 & 0xFF, this.color >> 8 & 0xFF, this.color & 0xFF))));
    }

    @Override
    public Font getFont() {
        return this.currentFont;
    }

    @Override
    public void setFont(Font font) {
        this.currentFont = font;
        SwtFont tmpFont = (SwtFont)((SwtFontManager)DeviceFactory.getDevice().getFontManager()).getFont(this.currentFont);
        this.g.setFont(tmpFont.getFont());
    }

    @Override
    public void clipRect(int x2, int y2, int width, int height) {
        Rectangle rect = new Rectangle(x2, y2, width, height);
        if (rect.x < this.getClipX()) {
            rect.x = this.getClipX();
        }
        if (rect.y < this.getClipY()) {
            rect.y = this.getClipY();
        }
        rect.width = x2 + width > this.getClipX() + this.getClipWidth() ? this.getClipX() + this.getClipWidth() - rect.x : x2 + width - rect.x;
        rect.height = y2 + height > this.getClipY() + this.getClipHeight() ? this.getClipY() + this.getClipHeight() - rect.y : y2 + height - rect.y;
        this.setClip(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public void setClip(int x2, int y2, int width, int height) {
        this.g.setClipping(x2, y2, width, height);
    }

    @Override
    public int getClipX() {
        Rectangle rect = this.g.getClipping();
        if (rect == null) {
            return 0;
        }
        return rect.x;
    }

    @Override
    public int getClipY() {
        Rectangle rect = this.g.getClipping();
        if (rect == null) {
            return 0;
        }
        return rect.y;
    }

    @Override
    public int getClipHeight() {
        Rectangle rect = this.g.getClipping();
        if (rect == null) {
            DisplayAccess da = MIDletBridge.getMIDletAccess().getDisplayAccess();
            return da.getCurrent().getHeight();
        }
        return rect.height;
    }

    @Override
    public int getClipWidth() {
        Rectangle rect = this.g.getClipping();
        if (rect == null) {
            DisplayAccess da = MIDletBridge.getMIDletAccess().getDisplayAccess();
            return da.getCurrent().getWidth();
        }
        return rect.width;
    }

    @Override
    public void drawArc(int x2, int y2, int width, int height, int startAngle, int arcAngle) {
        this.g.drawArc(x2, y2, width, height, startAngle, arcAngle);
    }

    @Override
    public void drawImage(Image img, int x2, int y2, int anchor) {
        int newx = x2;
        int newy = y2;
        if (anchor == 0) {
            anchor = 20;
        }
        if ((anchor & 8) != 0) {
            newx -= img.getWidth();
        } else if ((anchor & 1) != 0) {
            newx -= img.getWidth() / 2;
        }
        if ((anchor & 0x20) != 0) {
            newy -= img.getHeight();
        } else if ((anchor & 2) != 0) {
            newy -= img.getHeight() / 2;
        }
        if (img.isMutable()) {
            this.g.drawImage(((SwtMutableImage)img).getImage(), newx, newy);
        } else {
            this.g.drawImage(((SwtImmutableImage)img).getImage(), newx, newy);
        }
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.g.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawRect(int x2, int y2, int width, int height) {
        this.drawLine(x2, y2, x2 + width, y2);
        this.drawLine(x2 + width, y2, x2 + width, y2 + height);
        this.drawLine(x2 + width, y2 + height, x2, y2 + height);
        this.drawLine(x2, y2 + height, x2, y2);
    }

    @Override
    public void drawRegion(Image src, int x_src, int y_src, int width, int height, int transform, int x_dst, int y_dst, int anchor) {
        super.drawRegion(src, x_src, y_src, width, height, transform, x_dst, y_dst, anchor);
    }

    @Override
    public void drawRGB(int[] rgbData, int offset, int scanlength, int x2, int y2, int width, int height, boolean processAlpha) {
        super.drawRGB(rgbData, offset, scanlength, x2, y2, width, height, processAlpha);
    }

    @Override
    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        int[] points = new int[]{x1, y1, x2, y2, x3, y3};
        this.g.fillPolygon(points);
    }

    @Override
    public void drawRoundRect(int x2, int y2, int width, int height, int arcWidth, int arcHeight) {
        this.g.drawRoundRectangle(x2, y2, width, height, arcWidth, arcHeight);
    }

    @Override
    public void drawString(String str, int x2, int y2, int anchor) {
        int newx = x2;
        int newy = y2;
        if (anchor == 0) {
            anchor = 20;
        }
        if ((anchor & 2) != 0) {
            newy -= this.g.getFontMetrics().getAscent();
        } else if ((anchor & 0x20) != 0) {
            newy -= this.g.getFontMetrics().getHeight();
        }
        if ((anchor & 1) != 0) {
            newx -= this.g.stringWidth(str) / 2;
        } else if ((anchor & 8) != 0) {
            newx -= this.g.stringWidth(str);
        }
        boolean textAntialiasing = ((SwtFontManager)DeviceFactory.getDevice().getFontManager()).getAntialiasing();
        boolean graphicsAntialiasing = this.g.getAntialias();
        if (textAntialiasing != graphicsAntialiasing) {
            this.g.setAntialias(textAntialiasing);
        }
        this.g.drawString(str, newx, newy, true);
        if (textAntialiasing != graphicsAntialiasing) {
            this.g.setAntialias(graphicsAntialiasing);
        }
        if ((this.currentFont.getStyle() & 4) != 0) {
            this.g.drawLine(newx, newy + 1, newx + this.g.stringWidth(str), newy + 1);
        }
    }

    @Override
    public void fillArc(int x2, int y2, int width, int height, int startAngle, int arcAngle) {
        Color tmp = this.g.getBackground();
        this.g.setBackground(this.g.getForeground());
        this.g.fillArc(x2, y2, width, height, startAngle, arcAngle);
        this.g.setBackground(tmp);
    }

    @Override
    public void fillRect(int x2, int y2, int width, int height) {
        Color tmp = this.g.getBackground();
        this.g.setBackground(this.g.getForeground());
        this.g.fillRectangle(x2, y2, width, height);
        this.g.setBackground(tmp);
    }

    @Override
    public void fillRoundRect(int x2, int y2, int width, int height, int arcWidth, int arcHeight) {
        this.g.fillRoundRectangle(x2, y2, width, height, arcWidth, arcHeight);
    }

    @Override
    public void translate(int x2, int y2) {
        super.translate(x2, y2);
        this.g.translate(x2, y2);
    }
}

