/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.device.swt;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.microemu.DisplayAccess;
import org.microemu.EmulatorContext;
import org.microemu.MIDletAccess;
import org.microemu.MIDletBridge;
import org.microemu.app.ui.swt.ImageFilter;
import org.microemu.app.ui.swt.SwtDeviceComponent;
import org.microemu.app.ui.swt.SwtGraphics;
import org.microemu.app.util.IOUtils;
import org.microemu.device.Device;
import org.microemu.device.DeviceFactory;
import org.microemu.device.MutableImage;
import org.microemu.device.impl.Button;
import org.microemu.device.impl.Color;
import org.microemu.device.impl.DeviceDisplayImpl;
import org.microemu.device.impl.PositionedImage;
import org.microemu.device.impl.Rectangle;
import org.microemu.device.impl.Shape;
import org.microemu.device.impl.SoftButton;
import org.microemu.device.swt.BWImageFilter;
import org.microemu.device.swt.GrayImageFilter;
import org.microemu.device.swt.RGBImageFilter;
import org.microemu.device.swt.SwtButton;
import org.microemu.device.swt.SwtDisplayGraphics;
import org.microemu.device.swt.SwtImmutableImage;
import org.microemu.device.swt.SwtMutableImage;
import org.microemu.device.swt.SwtSoftButton;

public class SwtDeviceDisplay
implements DeviceDisplayImpl {
    EmulatorContext context;
    Rectangle displayRectangle;
    Rectangle displayPaintable;
    boolean isColor;
    int numColors;
    int numAlphaLevels;
    Color backgroundColor;
    Color foregroundColor;
    PositionedImage mode123Image;
    PositionedImage modeAbcUpperImage;
    PositionedImage modeAbcLowerImage;

    public SwtDeviceDisplay(EmulatorContext context) {
        this.context = context;
    }

    @Override
    public MutableImage getDisplayImage() {
        return this.context.getDisplayComponent().getDisplayImage();
    }

    @Override
    public int getHeight() {
        return this.displayPaintable.height;
    }

    @Override
    public int getWidth() {
        return this.displayPaintable.width;
    }

    @Override
    public int getFullHeight() {
        return this.displayRectangle.height;
    }

    @Override
    public int getFullWidth() {
        return this.displayRectangle.width;
    }

    @Override
    public boolean isColor() {
        return this.isColor;
    }

    @Override
    public boolean isFullScreenMode() {
        MIDletAccess ma = MIDletBridge.getMIDletAccess();
        if (ma == null) {
            return false;
        }
        DisplayAccess da = ma.getDisplayAccess();
        if (da == null) {
            return false;
        }
        return da.isFullScreenMode();
    }

    @Override
    public int numAlphaLevels() {
        return this.numAlphaLevels;
    }

    @Override
    public int numColors() {
        return this.numColors;
    }

    public void paintControls(SwtGraphics g2) {
        Device device = DeviceFactory.getDevice();
        g2.setBackground(g2.getColor(new RGB(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue())));
        g2.fillRectangle(0, 0, this.displayRectangle.width, this.displayPaintable.y);
        g2.fillRectangle(0, this.displayPaintable.y, this.displayPaintable.x, this.displayPaintable.height);
        g2.fillRectangle(this.displayPaintable.x + this.displayPaintable.width, this.displayPaintable.y, this.displayRectangle.width - this.displayPaintable.x - this.displayPaintable.width, this.displayPaintable.height);
        g2.fillRectangle(0, this.displayPaintable.y + this.displayPaintable.height, this.displayRectangle.width, this.displayRectangle.height - this.displayPaintable.y - this.displayPaintable.height);
        g2.setForeground(g2.getColor(new RGB(this.foregroundColor.getRed(), this.foregroundColor.getGreen(), this.foregroundColor.getBlue())));
        Enumeration s2 = device.getSoftButtons().elements();
        while (s2.hasMoreElements()) {
            ((SwtSoftButton)s2.nextElement()).paint(g2);
        }
        int inputMode = device.getInputMethod().getInputMode();
        if (inputMode == 1) {
            g2.drawImage(((SwtImmutableImage)this.mode123Image.getImage()).getImage(), this.mode123Image.getRectangle().x, this.mode123Image.getRectangle().y);
        } else if (inputMode == 2) {
            g2.drawImage(((SwtImmutableImage)this.modeAbcUpperImage.getImage()).getImage(), this.modeAbcUpperImage.getRectangle().x, this.modeAbcUpperImage.getRectangle().y);
        } else if (inputMode == 3) {
            g2.drawImage(((SwtImmutableImage)this.modeAbcLowerImage.getImage()).getImage(), this.modeAbcLowerImage.getRectangle().x, this.modeAbcLowerImage.getRectangle().y);
        }
    }

    public void paintDisplayable(SwtGraphics g2, int x2, int y2, int width, int height) {
        MIDletAccess ma = MIDletBridge.getMIDletAccess();
        if (ma == null) {
            return;
        }
        DisplayAccess da = ma.getDisplayAccess();
        if (da == null) {
            return;
        }
        Displayable current = da.getCurrent();
        if (current == null) {
            return;
        }
        g2.setForeground(g2.getColor(new RGB(this.foregroundColor.getRed(), this.foregroundColor.getGreen(), this.foregroundColor.getBlue())));
        org.eclipse.swt.graphics.Rectangle oldclip = g2.getClipping();
        if (!(current instanceof Canvas) || ((Canvas)current).getWidth() != this.displayRectangle.width || ((Canvas)current).getHeight() != this.displayRectangle.height) {
            g2.translate(this.displayPaintable.x, this.displayPaintable.y);
        }
        g2.setClipping(new org.eclipse.swt.graphics.Rectangle(x2, y2, width, height));
        org.eclipse.swt.graphics.Font oldf = g2.getFont();
        ma.getDisplayAccess().paint(new SwtDisplayGraphics(g2, this.getDisplayImage()));
        g2.setFont(oldf);
        if (!(current instanceof Canvas) || ((Canvas)current).getWidth() != this.displayRectangle.width || ((Canvas)current).getHeight() != this.displayRectangle.height) {
            g2.translate(-this.displayPaintable.x, -this.displayPaintable.y);
        }
        g2.setClipping(oldclip);
    }

    @Override
    public void repaint(int x2, int y2, int width, int height) {
        this.context.getDisplayComponent().repaintRequest(x2, y2, width, height);
    }

    @Override
    public void setScrollDown(boolean state) {
        Enumeration en = DeviceFactory.getDevice().getSoftButtons().elements();
        while (en.hasMoreElements()) {
            SoftButton button = (SoftButton)en.nextElement();
            if (button.getType() != 2 || !button.getName().equals("down")) continue;
            button.setVisible(state);
        }
    }

    @Override
    public void setScrollUp(boolean state) {
        Enumeration en = DeviceFactory.getDevice().getSoftButtons().elements();
        while (en.hasMoreElements()) {
            SoftButton button = (SoftButton)en.nextElement();
            if (button.getType() != 2 || !button.getName().equals("up")) continue;
            button.setVisible(state);
        }
    }

    public Rectangle getDisplayRectangle() {
        return this.displayRectangle;
    }

    public Rectangle getDisplayPaintable() {
        return this.displayPaintable;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    @Override
    public Image createImage(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException();
        }
        return new SwtMutableImage(width, height);
    }

    @Override
    public Image createImage(String name) throws IOException {
        return this.getImage(name);
    }

    @Override
    public Image createImage(Image source) {
        if (source.isMutable()) {
            return new SwtImmutableImage((SwtMutableImage)source);
        }
        return source;
    }

    @Override
    public Image createImage(byte[] imageData, int imageOffset, int imageLength) {
        ByteArrayInputStream is = new ByteArrayInputStream(imageData, imageOffset, imageLength);
        try {
            return this.getImage(is);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    @Override
    public Image createImage(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException();
        }
        return this.getImage(is);
    }

    @Override
    public void setNumAlphaLevels(int i2) {
        this.numAlphaLevels = i2;
    }

    @Override
    public void setNumColors(int i2) {
        this.numColors = i2;
    }

    @Override
    public void setIsColor(boolean b2) {
        this.isColor = b2;
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    @Override
    public void setForegroundColor(Color color) {
        this.foregroundColor = color;
    }

    @Override
    public void setDisplayRectangle(Rectangle rectangle) {
        this.displayRectangle = rectangle;
    }

    @Override
    public void setDisplayPaintable(Rectangle rectangle) {
        this.displayPaintable = rectangle;
    }

    @Override
    public void setMode123Image(PositionedImage object) {
        this.mode123Image = object;
    }

    @Override
    public void setModeAbcLowerImage(PositionedImage object) {
        this.modeAbcLowerImage = object;
    }

    @Override
    public void setModeAbcUpperImage(PositionedImage object) {
        this.modeAbcUpperImage = object;
    }

    @Override
    public Image createSystemImage(URL url) throws IOException {
        return new SwtImmutableImage(SwtDeviceComponent.createImage(url.openStream()));
    }

    private Image getImage(String str) throws IOException {
        InputStream is;
        Object midlet = MIDletBridge.getCurrentMIDlet();
        if (midlet == null) {
            midlet = this.getClass();
        }
        if ((is = midlet.getClass().getResourceAsStream(str)) == null) {
            throw new IOException(String.valueOf(str) + " could not be found.");
        }
        try {
            Image image = this.getImage(is);
            return image;
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    private Image getImage(InputStream is) throws IOException {
        ImageFilter filter = null;
        filter = this.isColor() ? new RGBImageFilter() : (this.numColors() == 2 ? new BWImageFilter() : new GrayImageFilter());
        return new SwtImmutableImage(SwtDeviceComponent.createImage(is, filter));
    }

    @Override
    public Button createButton(int skinVersion, String name, Shape shape, int keyCode, String keyboardKeys, String keyboardChars, Hashtable inputToChars, boolean modeChange) {
        return new SwtButton(name, shape, keyCode, keyboardKeys, inputToChars);
    }

    @Override
    public SoftButton createSoftButton(int skinVersion, String name, Shape shape, int keyCode, String keyName, Rectangle paintable, String alignmentName, Vector commands, Font font) {
        return new SwtSoftButton(name, shape, keyCode, keyName, paintable, alignmentName, commands, font);
    }

    @Override
    public SoftButton createSoftButton(int skinVersion, String name, Rectangle paintable, Image normalImage, Image pressedImage) {
        return new SwtSoftButton(name, paintable, normalImage, pressedImage);
    }

    @Override
    public Image createRGBImage(int[] rgb, int width, int height, boolean processAlpha) {
        if (rgb == null) {
            throw new NullPointerException();
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException();
        }
        org.eclipse.swt.graphics.Image img = SwtDeviceComponent.createImage(width, height);
        ImageData imageData = img.getImageData();
        if (!processAlpha) {
            int l2 = rgb.length;
            int[] rgbAux = new int[l2];
            int i2 = 0;
            while (i2 < l2) {
                rgbAux[i2] = rgb[i2] | 0xFF000000;
                ++i2;
            }
            rgb = rgbAux;
        }
        int y2 = 0;
        while (y2 < height) {
            imageData.setPixels(0, y2, width, rgb, y2 * width);
            ++y2;
        }
        ImageFilter filter = null;
        filter = this.isColor() ? new RGBImageFilter() : (this.numColors() == 2 ? new BWImageFilter() : new GrayImageFilter());
        return new SwtImmutableImage(SwtDeviceComponent.createImage(imageData));
    }

    @Override
    public Image createImage(Image image, int x2, int y2, int width, int height, int transform) {
        int rowIncr;
        int colIncr;
        int offset;
        if (image == null) {
            throw new NullPointerException();
        }
        if (x2 + width > image.getWidth() || y2 + height > image.getHeight() || width <= 0 || height <= 0 || x2 < 0 || y2 < 0) {
            throw new IllegalArgumentException("Area out of Image");
        }
        int[] rgbData = new int[height * width];
        int[] rgbTransformedData = new int[height * width];
        if (image instanceof SwtImmutableImage) {
            ((SwtImmutableImage)image).getRGB(rgbData, 0, width, x2, y2, width, height);
        } else {
            ((SwtMutableImage)image).getRGB(rgbData, 0, width, x2, y2, width, height);
        }
        switch (transform) {
            case 0: {
                offset = 0;
                colIncr = 1;
                rowIncr = 0;
                break;
            }
            case 5: {
                offset = (height - 1) * width;
                colIncr = -width;
                rowIncr = height * width + 1;
                int temp = width;
                width = height;
                height = temp;
                break;
            }
            case 3: {
                offset = height * width - 1;
                colIncr = -1;
                rowIncr = 0;
                break;
            }
            case 6: {
                offset = width - 1;
                colIncr = width;
                rowIncr = -(height * width) - 1;
                int temp = width;
                width = height;
                height = temp;
                break;
            }
            case 2: {
                offset = width - 1;
                colIncr = -1;
                rowIncr = width << 1;
                break;
            }
            case 7: {
                offset = height * width - 1;
                colIncr = -width;
                rowIncr = height * width - 1;
                int temp = width;
                width = height;
                height = temp;
                break;
            }
            case 1: {
                offset = (height - 1) * width;
                colIncr = 1;
                rowIncr = -(width << 1);
                break;
            }
            case 4: {
                offset = 0;
                colIncr = width;
                rowIncr = -(height * width) + 1;
                int temp = width;
                width = height;
                height = temp;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad transform");
            }
        }
        int row = 0;
        int i2 = 0;
        while (row < height) {
            int col = 0;
            while (col < width) {
                rgbTransformedData[i2] = rgbData[offset];
                ++col;
                offset += colIncr;
                ++i2;
            }
            ++row;
            offset += rowIncr;
        }
        rgbData = null;
        image = null;
        return this.createRGBImage(rgbTransformedData, width, height, true);
    }

    @Override
    public boolean isResizable() {
        return false;
    }

    @Override
    public void setResizable(boolean state) {
    }
}

