/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.device.j2se;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import org.microemu.device.j2se.J2SEFont;
import org.microemu.log.Logger;

public class J2SETrueTypeFont
implements J2SEFont {
    private static final Graphics2D graphics = (Graphics2D)new BufferedImage(1, 1, 2).getGraphics();
    private URL url;
    private String style;
    private int size;
    private boolean antialiasing;
    private boolean initialized;
    private FontMetrics fontMetrics;

    public J2SETrueTypeFont(URL url, String style, int size, boolean antialiasing) {
        this.url = url;
        this.style = style.toLowerCase();
        this.size = size;
        this.antialiasing = antialiasing;
        this.initialized = false;
    }

    @Override
    public void setAntialiasing(boolean antialiasing) {
        if (this.antialiasing != antialiasing) {
            this.antialiasing = antialiasing;
            this.initialized = false;
        }
    }

    @Override
    public int charWidth(char ch) {
        this.checkInitialized();
        return this.fontMetrics.charWidth(ch);
    }

    @Override
    public int charsWidth(char[] ch, int offset, int length) {
        this.checkInitialized();
        return this.fontMetrics.charsWidth(ch, offset, length);
    }

    @Override
    public int getBaselinePosition() {
        this.checkInitialized();
        return this.fontMetrics.getAscent();
    }

    @Override
    public int getHeight() {
        this.checkInitialized();
        return this.fontMetrics.getHeight();
    }

    @Override
    public int stringWidth(String str) {
        this.checkInitialized();
        return this.fontMetrics.stringWidth(str);
    }

    @Override
    public Font getFont() {
        this.checkInitialized();
        return this.fontMetrics.getFont();
    }

    private synchronized void checkInitialized() {
        if (!this.initialized) {
            int awtStyle = 0;
            if (this.style.indexOf("plain") != -1) {
                awtStyle |= 0;
            }
            if (this.style.indexOf("bold") != -1) {
                awtStyle |= 1;
            }
            if (this.style.indexOf("italic") != -1) {
                awtStyle |= 2;
            }
            this.style.indexOf("underlined");
            if (this.antialiasing) {
                graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            } else {
                graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            }
            try {
                Font baseFont = Font.createFont(0, this.url.openStream());
                this.fontMetrics = graphics.getFontMetrics(baseFont.deriveFont(awtStyle, this.size));
                this.initialized = true;
            }
            catch (FontFormatException ex) {
                Logger.error(ex);
            }
            catch (IOException ex) {
                Logger.error(ex);
            }
        }
    }
}

