/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.device.j2se;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.microemu.device.Device;
import org.microemu.device.DeviceFactory;
import org.microemu.device.impl.ButtonName;
import org.microemu.device.impl.Rectangle;
import org.microemu.device.impl.SoftButton;
import org.microemu.device.j2se.J2SEButton;
import org.microemu.log.Logger;

public class J2SEDeviceButtonsHelper {
    private static Map devices = new WeakHashMap();

    public static SoftButton getSoftButton(MouseEvent ev) {
        for (SoftButton button : DeviceFactory.getDevice().getSoftButtons()) {
            Rectangle pb;
            if (!button.isVisible() || (pb = button.getPaintable()) == null || !pb.contains(ev.getX(), ev.getY())) continue;
            return button;
        }
        return null;
    }

    public static J2SEButton getSkinButton(MouseEvent ev) {
        Enumeration en = DeviceFactory.getDevice().getButtons().elements();
        while (en.hasMoreElements()) {
            J2SEButton button = (J2SEButton)en.nextElement();
            if (button.getShape() == null || !button.getShape().contains(ev.getX(), ev.getY())) continue;
            return button;
        }
        return null;
    }

    public static J2SEButton getButton(KeyEvent ev) {
        DeviceInformation inf = J2SEDeviceButtonsHelper.getDeviceInformation();
        J2SEButton button = (J2SEButton)inf.keyboardCharCodes.get(new Integer(ev.getKeyChar()));
        if (button != null) {
            return button;
        }
        return (J2SEButton)inf.keyboardKeyCodes.get(new Integer(ev.getKeyCode()));
    }

    public static J2SEButton getButton(ButtonName functionalName) {
        DeviceInformation inf = J2SEDeviceButtonsHelper.getDeviceInformation();
        return (J2SEButton)inf.functions.get(functionalName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DeviceInformation getDeviceInformation() {
        Device dev = DeviceFactory.getDevice();
        Class<J2SEDeviceButtonsHelper> clazz = J2SEDeviceButtonsHelper.class;
        synchronized (J2SEDeviceButtonsHelper.class) {
            DeviceInformation inf = (DeviceInformation)devices.get(dev);
            if (inf == null) {
                inf = J2SEDeviceButtonsHelper.createDeviceInformation(dev);
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return inf;
        }
    }

    private static DeviceInformation createDeviceInformation(Device dev) {
        DeviceInformation inf = new DeviceInformation();
        boolean hasModeChange = false;
        Enumeration en = dev.getButtons().elements();
        while (en.hasMoreElements()) {
            J2SEButton button = (J2SEButton)en.nextElement();
            int[] keyCodes = button.getKeyboardKeyCodes();
            int i2 = 0;
            while (i2 < keyCodes.length) {
                inf.keyboardKeyCodes.put(new Integer(keyCodes[i2]), button);
                ++i2;
            }
            char[] charCodes = button.getKeyboardCharCodes();
            int i3 = 0;
            while (i3 < charCodes.length) {
                inf.keyboardCharCodes.put(new Integer(charCodes[i3]), button);
                ++i3;
            }
            inf.functions.put(button.getFunctionalName(), button);
            if (!button.isModeChange()) continue;
            hasModeChange = true;
        }
        if (!hasModeChange) {
            J2SEButton button = (J2SEButton)inf.functions.get(ButtonName.KEY_POUND);
            if (button != null) {
                button.setModeChange();
            } else {
                Logger.warn("Device has no ModeChange and POUND buttons");
            }
        }
        if (inf.functions.get(ButtonName.DELETE) == null) {
            dev.getButtons().add(new J2SEButton(ButtonName.DELETE));
        }
        if (inf.functions.get(ButtonName.BACK_SPACE) == null) {
            dev.getButtons().add(new J2SEButton(ButtonName.BACK_SPACE));
        }
        return inf;
    }

    private static class DeviceInformation {
        Map keyboardKeyCodes = new HashMap();
        Map keyboardCharCodes = new HashMap();
        Map functions = new HashMap();

        private DeviceInformation() {
        }
    }
}

