/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.device.impl;

import org.microemu.MIDletBridge;
import org.microemu.device.DeviceFactory;
import org.microemu.device.InputMethod;
import org.microemu.device.InputMethodEvent;
import org.microemu.device.InputMethodListener;
import org.microemu.device.impl.Button;

public abstract class InputMethodImpl
extends InputMethod
implements Runnable {
    protected boolean resetKey;
    protected Button lastButton = null;
    protected int lastButtonCharIndex = -1;
    private boolean cancel = false;
    private Thread t = new Thread((Runnable)this, "InputMethodThread");

    public InputMethodImpl() {
        this.t.setDaemon(true);
        this.t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.cancel = true;
        InputMethodImpl inputMethodImpl = this;
        synchronized (inputMethodImpl) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.cancel) {
            InputMethodImpl inputMethodImpl;
            try {
                this.resetKey = true;
                inputMethodImpl = this;
                synchronized (inputMethodImpl) {
                    this.wait(1500L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            inputMethodImpl = this;
            synchronized (inputMethodImpl) {
                int caret;
                if (this.resetKey && this.lastButton != null && this.inputMethodListener != null && (caret = this.inputMethodListener.getCaretPosition() + 1) <= this.inputMethodListener.getText().length()) {
                    this.lastButton = null;
                    this.lastButtonCharIndex = -1;
                    InputMethodEvent event = new InputMethodEvent(1, caret, this.inputMethodListener.getText());
                    this.inputMethodListener.caretPositionChanged(event);
                }
            }
        }
    }

    @Override
    public void setInputMethodListener(InputMethodListener l2) {
        super.setInputMethodListener(l2);
        this.lastButton = null;
        this.lastButtonCharIndex = -1;
    }

    public void pointerPressed(int x2, int y2) {
        if (DeviceFactory.getDevice().hasPointerEvents()) {
            MIDletBridge.getMIDletAccess().getDisplayAccess().pointerPressed(x2, y2);
        }
    }

    public void pointerReleased(int x2, int y2) {
        if (DeviceFactory.getDevice().hasPointerEvents()) {
            MIDletBridge.getMIDletAccess().getDisplayAccess().pointerReleased(x2, y2);
        }
    }

    public void pointerDragged(int x2, int y2) {
        if (DeviceFactory.getDevice().hasPointerMotionEvents()) {
            MIDletBridge.getMIDletAccess().getDisplayAccess().pointerDragged(x2, y2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertText(String str) {
        if (str.length() > 0) {
            int caret = this.inputMethodListener.getCaretPosition();
            String tmp = "";
            InputMethodImpl inputMethodImpl = this;
            synchronized (inputMethodImpl) {
                if (this.lastButton != null) {
                    ++caret;
                    this.lastButton = null;
                    this.lastButtonCharIndex = -1;
                }
                if (caret > 0) {
                    tmp = String.valueOf(tmp) + this.inputMethodListener.getText().substring(0, caret);
                }
                tmp = String.valueOf(tmp) + str;
                if (caret < this.inputMethodListener.getText().length()) {
                    tmp = String.valueOf(tmp) + this.inputMethodListener.getText().substring(caret);
                }
                caret += str.length();
            }
            if (!InputMethodImpl.validate(tmp, this.inputMethodListener.getConstraints())) {
                return;
            }
            InputMethodEvent event = new InputMethodEvent(2, caret, tmp);
            this.inputMethodListener.inputMethodTextChanged(event);
            event = new InputMethodEvent(1, caret, tmp);
            this.inputMethodListener.caretPositionChanged(event);
        }
    }

    protected char[] filterConstraints(char[] chars) {
        char[] result = new char[chars.length];
        int i2 = 0;
        int j2 = 0;
        while (i2 < chars.length) {
            switch (this.inputMethodListener.getConstraints() & 0xFFFF) {
                case 0: {
                    result[j2] = chars[i2];
                    ++j2;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if (!Character.isDigit(chars[i2]) && chars[i2] != '-') break;
                    result[j2] = chars[i2];
                    ++j2;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    if (chars[i2] == '\n') break;
                    result[j2] = chars[i2];
                    ++j2;
                    break;
                }
                case 5: {
                    if (!Character.isDigit(chars[i2]) && chars[i2] != '-' && chars[i2] != '.') break;
                    result[j2] = chars[i2];
                    ++j2;
                }
            }
            ++i2;
        }
        if (i2 != j2) {
            char[] newresult = new char[j2];
            System.arraycopy(result, 0, newresult, 0, j2);
            result = newresult;
        }
        return result;
    }

    protected char[] filterInputMode(char[] chars) {
        if (chars == null) {
            return new char[0];
        }
        int inputMode = this.getInputMode();
        char[] result = new char[chars.length];
        int i2 = 0;
        int j2 = 0;
        while (i2 < chars.length) {
            if (inputMode == 2) {
                result[j2] = Character.toUpperCase(chars[i2]);
                ++j2;
            } else if (inputMode == 3) {
                result[j2] = Character.toLowerCase(chars[i2]);
                ++j2;
            } else if (inputMode == 1 && (Character.isDigit(chars[i2]) || chars[i2] == '-' || chars[i2] == '.')) {
                result[j2] = chars[i2];
                ++j2;
            }
            ++i2;
        }
        if (i2 != j2) {
            char[] newresult = new char[j2];
            System.arraycopy(result, 0, newresult, 0, j2);
            result = newresult;
        }
        return result;
    }
}

