/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import nanoxml.XMLElement;
import org.microemu.app.util.XMLItem;
import org.microemu.log.Logger;

public class MidletURLReference
implements XMLItem {
    private String name;
    private String url;

    public MidletURLReference() {
    }

    public MidletURLReference(String name, String url) {
        this.name = name;
        this.url = url;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MidletURLReference)) {
            return false;
        }
        return ((MidletURLReference)obj).url.equals(this.url);
    }

    public String toString() {
        URL u2;
        try {
            u2 = new URL(this.url);
        }
        catch (MalformedURLException e2) {
            Logger.error(e2);
            return this.url;
        }
        StringBuffer b2 = new StringBuffer();
        String scheme = u2.getProtocol();
        if (scheme.equals("file") || scheme.startsWith("http")) {
            b2.append(scheme).append("://");
            if (u2.getHost() != null) {
                b2.append(u2.getHost());
            }
            Vector<String> pathComponents = new Vector<String>();
            String pathSeparator = "/";
            StringTokenizer st = new StringTokenizer(u2.getPath(), "/");
            while (st.hasMoreTokens()) {
                pathComponents.add(st.nextToken());
            }
            if (pathComponents.size() > 3) {
                b2.append("/");
                b2.append(pathComponents.get(0));
                b2.append("/").append("...").append("/");
                b2.append(pathComponents.get(pathComponents.size() - 2));
                b2.append("/");
                b2.append(pathComponents.get(pathComponents.size() - 1));
            } else {
                b2.append(u2.getPath());
            }
        } else {
            b2.append(this.url);
        }
        if (this.name != null) {
            b2.append(" - ");
            b2.append(this.name);
        }
        return b2.toString();
    }

    @Override
    public void read(XMLElement xml) {
        this.name = xml.getChildString("name", "");
        this.url = xml.getChildString("url", "");
    }

    @Override
    public void save(XMLElement xml) {
        xml.removeChildren();
        xml.addChild("name", this.name);
        xml.addChild("url", this.url);
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }
}

