/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.net.NetworkInterface;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.microemu.device.Device;
import org.microemu.log.Logger;

public class MIDletSystemProperties {
    public static boolean applyToJavaSystemProperties = true;
    private static final Map props = new HashMap();
    private static final Map permissions = new HashMap();
    private static Map systemPropertiesPreserve;
    private static List systemPropertiesDevice;
    private static boolean wanrOnce;
    private static boolean initialized;
    private static AccessControlContext acc;

    static {
        wanrOnce = true;
        initialized = false;
    }

    private static void initOnce() {
        if (initialized) {
            return;
        }
        initialized = true;
        String s1 = "AC";
        String s2 = "ulato";
        MIDletSystemProperties.setProperty("microedition.platform", "AV" + s1 + "SEm" + s2 + "r" + "-1/0.1" + " Java-" + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + " " + " " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " User/" + System.getProperty("user.name"));
        MIDletSystemProperties.setProperty("microedition.encoding", MIDletSystemProperties.getSystemProperty("file.encoding"));
        s1 = String.valueOf(s1) + s2;
        String hddresult = "";
        try {
            String line;
            File file = File.createTempFile("realhowto", ".vbs");
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            String vbs = "Set objFSO = CreateObject(\"Scripting.FileSystemObject\")\nSet colDrives = objFSO.Drives\nSet objDrive = colDrives.item(\"C\")\nWscript.Echo objDrive.SerialNumber";
            fw.write(vbs);
            fw.close();
            Process p2 = Runtime.getRuntime().exec("cscript //NoLogo " + file.getPath());
            BufferedReader input = new BufferedReader(new InputStreamReader(p2.getInputStream()));
            while ((line = input.readLine()) != null) {
                hddresult = String.valueOf(hddresult) + line;
            }
            input.close();
        }
        catch (Exception file) {
            // empty catch block
        }
        MIDletSystemProperties.setProperty("net.avacs.hddid", hddresult);
        String macresult = "";
        try {
            Enumeration<NetworkInterface> nilist = NetworkInterface.getNetworkInterfaces();
            while (nilist.hasMoreElements()) {
                NetworkInterface ni = nilist.nextElement();
                byte[] mac = ni.getHardwareAddress();
                if (mac == null) continue;
                if (macresult == null || macresult.length() <= 8) {
                    macresult = "";
                    int k2 = 0;
                    while (k2 < mac.length) {
                        macresult = String.valueOf(macresult) + (mac[k2] & 0xFF);
                        ++k2;
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception nilist) {
            // empty catch block
        }
        MIDletSystemProperties.setProperty("net.avacs.mcid", macresult);
        String resultIMEI = "2";
        long hdd = 0L;
        try {
            hdd = Long.parseLong(hddresult);
        }
        catch (Exception ex) {
            try {
                hdd = Long.parseLong(hddresult, 16);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        long mac = 0L;
        try {
            mac = Long.parseLong(macresult);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (hdd > 0L) {
            resultIMEI = "" + hdd;
        }
        if (resultIMEI.length() < 8 && mac > 256L) {
            resultIMEI = "" + mac;
        }
        String ss = "acs.im";
        MIDletSystemProperties.setProperty("net.av" + ss + "ei", resultIMEI);
        ss = String.valueOf(ss) + ss;
    }

    public static void initContext() {
        acc = AccessController.getContext();
    }

    public static String getProperty(String key) {
        MIDletSystemProperties.initOnce();
        if (props.containsKey(key)) {
            return (String)props.get(key);
        }
        String v2 = MIDletSystemProperties.getDynamicProperty(key);
        if (v2 != null) {
            return v2;
        }
        try {
            return MIDletSystemProperties.getSystemProperty(key);
        }
        catch (SecurityException e2) {
            return null;
        }
    }

    public static String getSystemProperty(String key) {
        try {
            if (acc != null) {
                return MIDletSystemProperties.getSystemPropertySecure(key);
            }
            return System.getProperty(key);
        }
        catch (SecurityException e2) {
            return null;
        }
    }

    private static String getSystemPropertySecure(final String key) {
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    return System.getProperty(key);
                }
            }, acc);
        }
        catch (Throwable e2) {
            return null;
        }
    }

    private static String getDynamicProperty(String key) {
        if (key.equals("microedition.locale")) {
            return Locale.getDefault().getLanguage();
        }
        return null;
    }

    public static Set getPropertiesSet() {
        MIDletSystemProperties.initOnce();
        return props.entrySet();
    }

    public static String setProperty(String key, String value) {
        block5: {
            MIDletSystemProperties.initOnce();
            if (applyToJavaSystemProperties) {
                try {
                    if (value == null) {
                        System.getProperties().remove(key);
                    } else {
                        System.setProperty(key, value);
                    }
                }
                catch (SecurityException e2) {
                    if (!wanrOnce) break block5;
                    wanrOnce = false;
                    Logger.error("Cannot update Java System.Properties", e2);
                    Logger.debug("Continue ME2 operations with no updates to system Properties");
                }
            }
        }
        return props.put(key, value);
    }

    public static String clearProperty(String key) {
        block3: {
            if (applyToJavaSystemProperties) {
                try {
                    System.getProperties().remove(key);
                }
                catch (SecurityException e2) {
                    if (!wanrOnce) break block3;
                    wanrOnce = false;
                    Logger.error("Cannot update Java System.Properties", e2);
                }
            }
        }
        return (String)props.remove(key);
    }

    public static void setProperties(Map properties) {
        MIDletSystemProperties.initOnce();
        for (Map.Entry e2 : properties.entrySet()) {
            MIDletSystemProperties.setProperty((String)e2.getKey(), (String)e2.getValue());
        }
    }

    public static int getPermission(String permission) {
        Integer value = (Integer)permissions.get(permission);
        if (value == null) {
            return -1;
        }
        return value;
    }

    public static void setPermission(String permission, int value) {
        permissions.put(permission, new Integer(value));
    }

    public static void setDevice(Device newDevice) {
        MIDletSystemProperties.initOnce();
        if (systemPropertiesDevice != null) {
            Iterator iter = systemPropertiesDevice.iterator();
            while (iter.hasNext()) {
                MIDletSystemProperties.clearProperty((String)iter.next());
            }
        }
        if (systemPropertiesPreserve != null) {
            for (Map.Entry e2 : systemPropertiesPreserve.entrySet()) {
                MIDletSystemProperties.setProperty((String)e2.getKey(), (String)e2.getValue());
            }
        }
        systemPropertiesDevice = new Vector();
        systemPropertiesPreserve = new HashMap();
        for (Map.Entry e2 : newDevice.getSystemProperties().entrySet()) {
            String key = (String)e2.getKey();
            if (props.containsKey(key)) {
                systemPropertiesPreserve.put(key, props.get(key));
            } else {
                systemPropertiesDevice.add(key);
            }
            MIDletSystemProperties.setProperty(key, (String)e2.getValue());
        }
    }
}

