/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app.util;

import java.io.OutputStream;
import java.io.PrintStream;
import org.microemu.log.Logger;

public class MIDletOutputStreamRedirector
extends PrintStream {
    private static final boolean keepMultiLinePrint = true;
    public static final PrintStream out = MIDletOutputStreamRedirector.outPrintStream();
    public static final PrintStream err = MIDletOutputStreamRedirector.errPrintStream();
    private boolean isErrorStream;

    static {
        Logger.addLogOrigin(MIDletOutputStreamRedirector.class);
        Logger.addLogOrigin(OutputStream2Log.class);
    }

    private MIDletOutputStreamRedirector(boolean error) {
        super(new OutputStream2Log(error));
        this.isErrorStream = error;
    }

    private static PrintStream outPrintStream() {
        return new MIDletOutputStreamRedirector(false);
    }

    private static PrintStream errPrintStream() {
        return new MIDletOutputStreamRedirector(true);
    }

    @Override
    public void print(boolean b2) {
        super.print(b2);
    }

    @Override
    public void print(char c2) {
        super.print(c2);
    }

    @Override
    public void print(char[] s2) {
        super.print(s2);
    }

    @Override
    public void print(double d2) {
        super.print(d2);
    }

    @Override
    public void print(float f2) {
        super.print(f2);
    }

    @Override
    public void print(int i2) {
        super.print(i2);
    }

    @Override
    public void print(long l2) {
        super.print(l2);
    }

    @Override
    public void print(Object obj) {
        super.print(obj);
    }

    @Override
    public void print(String s2) {
        super.print(s2);
    }

    @Override
    public void println() {
        super.println();
    }

    @Override
    public void println(boolean x2) {
        super.println(x2);
    }

    @Override
    public void println(char x2) {
        super.println(x2);
    }

    @Override
    public void println(char[] x2) {
        super.println(x2);
    }

    @Override
    public void println(double x2) {
        super.println(x2);
    }

    @Override
    public void println(float x2) {
        super.println(x2);
    }

    @Override
    public void println(int x2) {
        super.println(x2);
    }

    @Override
    public void println(long x2) {
        super.println(x2);
    }

    @Override
    public void println(Object x2) {
        super.flush();
        if (this.isErrorStream) {
            Logger.error(x2);
        } else {
            Logger.info(x2);
        }
    }

    @Override
    public void println(String x2) {
        super.flush();
        if (this.isErrorStream) {
            Logger.error(x2);
        } else {
            Logger.info(x2);
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        super.write(buf, off, len);
    }

    @Override
    public void write(int b2) {
        super.write(b2);
    }

    private static class OutputStream2Log
    extends OutputStream {
        boolean isErrorStream;
        StringBuffer buffer = new StringBuffer();

        OutputStream2Log(boolean error) {
            this.isErrorStream = error;
        }

        @Override
        public void flush() {
            if (this.buffer.length() > 0) {
                this.write(10);
            }
        }

        @Override
        public void write(int b2) {
            if (b2 == 10 || b2 == 13) {
                if (this.buffer.length() > 0) {
                    if (this.isErrorStream) {
                        Logger.error(this.buffer.toString());
                    } else {
                        Logger.info(this.buffer.toString());
                    }
                    this.buffer = new StringBuffer();
                }
            } else {
                this.buffer.append((char)b2);
            }
        }
    }
}

