/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app.ui.swing;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.microemu.app.Common;
import org.microemu.app.ui.Message;
import org.microemu.app.util.IOUtils;
import org.microemu.log.Logger;

public class DropTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private static DataFlavor uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String", null);
    private static boolean debugImport = false;

    @Override
    public int getSourceActions(JComponent c2) {
        return 1;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        int i2 = 0;
        while (i2 < transferFlavors.length) {
            Class<?> representationclass = transferFlavors[i2].getRepresentationClass();
            if (representationclass != null && URL.class.isAssignableFrom(representationclass)) {
                if (debugImport) {
                    Logger.debug("acepted ", transferFlavors[i2]);
                }
                return true;
            }
            if (DataFlavor.javaFileListFlavor.equals(transferFlavors[i2])) {
                if (debugImport) {
                    Logger.debug("acepted ", transferFlavors[i2]);
                }
                return true;
            }
            if (DataFlavor.stringFlavor.equals(transferFlavors[i2])) {
                if (debugImport) {
                    Logger.debug("acepted ", transferFlavors[i2]);
                }
                return true;
            }
            if (uriListFlavor.equals(transferFlavors[i2])) {
                if (debugImport) {
                    Logger.debug("acepted ", transferFlavors[i2]);
                }
                return true;
            }
            if (debugImport) {
                Logger.debug(String.valueOf(i2) + " unknown import ", transferFlavors[i2]);
            }
            ++i2;
        }
        if (debugImport) {
            Logger.debug("import rejected");
        }
        return false;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t2) {
        DataFlavor[] transferFlavors = t2.getTransferDataFlavors();
        int i2 = 0;
        while (i2 < transferFlavors.length) {
            block31: {
                String path;
                Object data;
                if (DataFlavor.javaFileListFlavor.equals(transferFlavors[i2])) {
                    Logger.debug("importing", transferFlavors[i2]);
                    try {
                        List fileList = (List)t2.getTransferData(DataFlavor.javaFileListFlavor);
                        if (fileList.get(0) instanceof File) {
                            File f2 = (File)fileList.get(0);
                            if (Common.isMIDletUrlExtension(f2.getName())) {
                                Common.openMIDletUrlSafe(IOUtils.getCanonicalFileURL(f2));
                            } else {
                                Message.warn("Unable to open " + f2.getAbsolutePath() + ", Only JAD files are acepted");
                            }
                        } else {
                            Logger.debug("Unknown object in list ", fileList.get(0));
                        }
                    }
                    catch (UnsupportedFlavorException e2) {
                        Logger.debug(e2);
                    }
                    catch (IOException e3) {
                        Logger.debug(e3);
                    }
                    return true;
                }
                if (DataFlavor.stringFlavor.equals(transferFlavors[i2])) {
                    try {
                        data = t2.getTransferData(DataFlavor.stringFlavor);
                    }
                    catch (UnsupportedFlavorException e4) {
                        break block31;
                    }
                    catch (IOException e5) {
                        break block31;
                    }
                    if (data instanceof String) {
                        Logger.debug("importing", transferFlavors[i2]);
                        path = this.getPathString((String)data);
                        if (Common.isMIDletUrlExtension(path)) {
                            Common.openMIDletUrlSafe(path);
                        } else {
                            Message.warn("Unable to open " + path + ", Only JAD files are acepted");
                        }
                        return true;
                    }
                }
                if (uriListFlavor.equals(transferFlavors[i2])) {
                    try {
                        data = t2.getTransferData(uriListFlavor);
                    }
                    catch (UnsupportedFlavorException e6) {
                        break block31;
                    }
                    catch (IOException e7) {
                        break block31;
                    }
                    if (data instanceof String) {
                        Logger.debug("importing", transferFlavors[i2]);
                        path = this.getPathString((String)data);
                        if (Common.isMIDletUrlExtension(path)) {
                            Common.openMIDletUrlSafe(path);
                        } else {
                            Message.warn("Unable to open " + path + ", Only JAD files are acepted");
                        }
                        return true;
                    }
                }
                if (debugImport) {
                    Logger.debug(String.valueOf(i2) + " unknown importData ", transferFlavors[i2]);
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < transferFlavors.length) {
            Class<?> representationclass = transferFlavors[i2].getRepresentationClass();
            if (representationclass != null && URL.class.isAssignableFrom(representationclass)) {
                Logger.debug("importing", transferFlavors[i2]);
                try {
                    URL jadUrl = (URL)t2.getTransferData(transferFlavors[i2]);
                    String urlString = jadUrl.toExternalForm();
                    if (Common.isMIDletUrlExtension(urlString)) {
                        Common.openMIDletUrlSafe(urlString);
                    } else {
                        Message.warn("Unable to open " + urlString + ", Only JAD url are acepted");
                    }
                }
                catch (UnsupportedFlavorException e8) {
                    Logger.debug(e8);
                }
                catch (IOException e9) {
                    Logger.debug(e9);
                }
                return true;
            }
            ++i2;
        }
        return false;
    }

    private String getPathString(String path) {
        if (path == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(path.trim(), "\n\r");
        if (st.hasMoreTokens()) {
            return st.nextToken();
        }
        return path;
    }
}

