/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app.ui.noui;

import java.awt.Graphics;
import javax.microedition.lcdui.Displayable;
import org.microemu.DisplayAccess;
import org.microemu.DisplayComponent;
import org.microemu.MIDletAccess;
import org.microemu.MIDletBridge;
import org.microemu.app.ui.DisplayRepaintListener;
import org.microemu.device.Device;
import org.microemu.device.DeviceFactory;
import org.microemu.device.MutableImage;
import org.microemu.device.j2se.J2SEDeviceDisplay;
import org.microemu.device.j2se.J2SEMutableImage;

public class NoUiDisplayComponent
implements DisplayComponent {
    private J2SEMutableImage displayImage = null;
    private DisplayRepaintListener displayRepaintListener;

    @Override
    public void addDisplayRepaintListener(DisplayRepaintListener l2) {
        this.displayRepaintListener = l2;
    }

    @Override
    public void removeDisplayRepaintListener(DisplayRepaintListener l2) {
        if (this.displayRepaintListener == l2) {
            this.displayRepaintListener = null;
        }
    }

    @Override
    public MutableImage getDisplayImage() {
        return this.displayImage;
    }

    @Override
    public void repaintRequest(int x2, int y2, int width, int height) {
        MIDletAccess ma = MIDletBridge.getMIDletAccess();
        if (ma == null) {
            return;
        }
        DisplayAccess da = ma.getDisplayAccess();
        if (da == null) {
            return;
        }
        Displayable current = da.getCurrent();
        if (current == null) {
            return;
        }
        Device device = DeviceFactory.getDevice();
        if (device != null) {
            if (this.displayImage == null) {
                this.displayImage = new J2SEMutableImage(device.getDeviceDisplay().getFullWidth(), device.getDeviceDisplay().getFullHeight());
            }
            Graphics gc = this.displayImage.getImage().getGraphics();
            J2SEDeviceDisplay deviceDisplay = (J2SEDeviceDisplay)device.getDeviceDisplay();
            if (!deviceDisplay.isFullScreenMode()) {
                deviceDisplay.paintControls(gc);
            }
            deviceDisplay.paintDisplayable(gc, x2, y2, width, height);
            this.fireDisplayRepaint(this.displayImage);
        }
    }

    private void fireDisplayRepaint(MutableImage image) {
        if (this.displayRepaintListener != null) {
            this.displayRepaintListener.repaintInvoked(image);
        }
    }
}

