/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui.game;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.TiledLayer;

public class Sprite
extends Layer {
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    private int frame;
    private int[] sequence;
    private int refX;
    private int refY;
    private int cols;
    private int rows;
    private int transform;
    private Image img;
    private int collX;
    private int collY;
    private int collWidth;
    private int collHeight;
    private int[] rgbData;
    private int[] rgbDataAux;

    public Sprite(Image img) {
        this(img, img.getWidth(), img.getHeight());
    }

    public Sprite(Image img, int frameWidth, int frameHeight) {
        super(0, 0, frameWidth, frameHeight, true);
        if (img.getWidth() % frameWidth != 0 || img.getHeight() % frameHeight != 0) {
            throw new IllegalArgumentException();
        }
        this.img = img;
        this.cols = img.getWidth() / frameWidth;
        this.rows = img.getHeight() / frameHeight;
        this.collY = 0;
        this.collX = 0;
        this.collWidth = frameWidth;
        this.collHeight = frameHeight;
    }

    public Sprite(Sprite otherSprite) {
        super(otherSprite.getX(), otherSprite.getY(), otherSprite.getWidth(), otherSprite.getHeight(), otherSprite.isVisible());
        this.frame = otherSprite.frame;
        this.sequence = otherSprite.sequence;
        this.refX = otherSprite.refX;
        this.refY = otherSprite.refY;
        this.cols = otherSprite.cols;
        this.rows = otherSprite.rows;
        this.transform = otherSprite.transform;
        this.img = otherSprite.img;
        this.collX = otherSprite.collX;
        this.collY = otherSprite.collY;
        this.collWidth = otherSprite.collWidth;
        this.collHeight = otherSprite.collHeight;
    }

    public final boolean collidesWith(Image image, int iX, int iY, boolean pixelLevel) {
        if (image == null) {
            throw new IllegalArgumentException();
        }
        if (!this.isVisible()) {
            return false;
        }
        if (pixelLevel) {
            return this.collidesWithPixelLevel(image, iX, iY);
        }
        return this.collidesWith(image, iX, iY);
    }

    public final boolean collidesWith(TiledLayer layer, boolean pixelLevel) {
        if (layer == null) {
            throw new NullPointerException();
        }
        if (!this.isVisible()) {
            return false;
        }
        if (!layer.isVisible() || !this.isVisible()) {
            return false;
        }
        if (pixelLevel) {
            return this.collidesWithPixelLevel(layer, 0, 0);
        }
        return this.collidesWith(layer, 0, 0);
    }

    public final boolean collidesWith(Sprite otherSprite, boolean pixelLevel) {
        if (otherSprite == null) {
            throw new NullPointerException();
        }
        if (!otherSprite.isVisible() || !this.isVisible()) {
            return false;
        }
        if (pixelLevel) {
            return this.collidesWithPixelLevel(otherSprite, 0, 0);
        }
        return this.collidesWith(otherSprite, 0, 0);
    }

    public void defineReferencePixel(int x2, int y2) {
        this.refX = x2;
        this.refY = y2;
    }

    public int getRefPixelX() {
        return this.getX() + this.refX;
    }

    public int getRefPixelY() {
        return this.getY() + this.refY;
    }

    public void setRefPixelPosition(int x2, int y2) {
        int curRefY;
        int curRefX;
        int width = this.getWidth();
        int height = this.getHeight();
        switch (this.transform) {
            case 0: {
                curRefX = this.refX;
                curRefY = this.refY;
                break;
            }
            case 1: {
                curRefX = width - this.refX;
                curRefY = height - this.refY;
                break;
            }
            case 2: {
                curRefX = width - this.refX;
                curRefY = this.refY;
                break;
            }
            case 3: {
                curRefX = this.refX;
                curRefY = height - this.refY;
                break;
            }
            case 4: {
                curRefX = height - this.refY;
                curRefY = this.refX;
                break;
            }
            case 5: {
                curRefX = height - this.refY;
                curRefY = width - this.refX;
                break;
            }
            case 6: {
                curRefX = this.refY;
                curRefY = this.refX;
                break;
            }
            case 7: {
                curRefX = this.refY;
                curRefY = width - this.refX;
                break;
            }
            default: {
                return;
            }
        }
        this.setPosition(x2 - curRefX, y2 - curRefY);
    }

    public void defineCollisionRectangle(int x2, int y2, int width, int height) {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException();
        }
        this.collX = x2;
        this.collY = y2;
        this.collWidth = width;
        this.collHeight = height;
    }

    public void setFrameSequence(int[] sequence) {
        if (sequence == null) {
            this.sequence = null;
            return;
        }
        int max = this.rows * this.cols - 1;
        int l2 = sequence.length;
        if (l2 == 0) {
            throw new IllegalArgumentException();
        }
        int i2 = 0;
        while (i2 < l2) {
            int value = sequence[i2];
            if (value > max || value < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            ++i2;
        }
        this.sequence = sequence;
        this.frame = 0;
    }

    public final int getFrame() {
        return this.frame;
    }

    public int getFrameSequenceLength() {
        return this.sequence == null ? this.rows * this.cols : this.sequence.length;
    }

    public void setFrame(int frame) {
        int l2;
        int n2 = l2 = this.sequence == null ? this.rows * this.cols : this.sequence.length;
        if (frame < 0 || frame >= l2) {
            throw new IndexOutOfBoundsException();
        }
        this.frame = frame;
    }

    public void nextFrame() {
        this.frame = this.frame == (this.sequence == null ? this.rows * this.cols : this.sequence.length) - 1 ? 0 : ++this.frame;
    }

    public void prevFrame() {
        this.frame = this.frame == 0 ? (this.sequence == null ? this.rows * this.cols : this.sequence.length) - 1 : --this.frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(Image img, int frameWidth, int frameHeight) {
        Sprite sprite = this;
        synchronized (sprite) {
            int oldW = this.getWidth();
            int oldH = this.getHeight();
            int newW = img.getWidth();
            int newH = img.getHeight();
            this.setSize(frameWidth, frameHeight);
            if (img.getWidth() % frameWidth != 0 || img.getHeight() % frameHeight != 0) {
                throw new IllegalArgumentException();
            }
            this.img = img;
            int oldFrames = this.cols * this.rows;
            this.cols = img.getWidth() / frameWidth;
            this.rows = img.getHeight() / frameHeight;
            if (this.rows * this.cols < oldFrames) {
                this.sequence = null;
                this.frame = 0;
            }
            if (frameWidth != this.getWidth() || frameHeight != this.getHeight()) {
                this.defineCollisionRectangle(0, 0, frameWidth, frameHeight);
                this.rgbDataAux = null;
                this.rgbData = null;
                if (this.transform != 0) {
                    int dy;
                    int dx;
                    switch (this.transform) {
                        case 1: {
                            dx = newW - oldW;
                            dy = newH - oldH;
                            break;
                        }
                        case 2: {
                            dx = newW - oldW;
                            dy = 0;
                            break;
                        }
                        case 3: {
                            dx = 0;
                            dy = newH - oldH;
                            break;
                        }
                        case 4: {
                            dx = newH - oldH;
                            dy = 0;
                            break;
                        }
                        case 5: {
                            dx = newH - oldH;
                            dy = newW - oldW;
                            break;
                        }
                        case 6: {
                            dx = 0;
                            dy = 0;
                            break;
                        }
                        case 7: {
                            dx = 0;
                            dy = newW - oldW;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    this.move(dx, dy);
                }
            }
        }
    }

    @Override
    public final void paint(Graphics g2) {
        if (!this.isVisible()) {
            return;
        }
        int f2 = this.sequence == null ? this.frame : this.sequence[this.frame];
        int w2 = this.getWidth();
        int h2 = this.getHeight();
        int fx = w2 * (f2 % this.cols);
        int fy = h2 * (f2 / this.cols);
        g2.drawRegion(this.img, fx, fy, w2, h2, this.transform, this.getX(), this.getY(), 20);
    }

    public int getRawFrameCount() {
        return this.cols * this.rows;
    }

    public void setTransform(int transform) {
        int curRefY;
        int curRefX;
        int newRefY;
        int newRefX;
        if (this.transform == transform) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int currentTransform = this.transform;
        switch (transform) {
            case 0: {
                newRefX = this.refX;
                newRefY = this.refY;
                break;
            }
            case 1: {
                newRefX = width - this.refX;
                newRefY = height - this.refY;
                break;
            }
            case 2: {
                newRefX = width - this.refX;
                newRefY = this.refY;
                break;
            }
            case 3: {
                newRefX = this.refX;
                newRefY = height - this.refY;
                break;
            }
            case 4: {
                newRefX = height - this.refY;
                newRefY = this.refX;
                break;
            }
            case 5: {
                newRefX = height - this.refY;
                newRefY = width - this.refX;
                break;
            }
            case 6: {
                newRefX = this.refY;
                newRefY = this.refX;
                break;
            }
            case 7: {
                newRefX = this.refY;
                newRefY = width - this.refX;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        switch (currentTransform) {
            case 0: {
                curRefX = this.refX;
                curRefY = this.refY;
                break;
            }
            case 1: {
                curRefX = width - this.refX;
                curRefY = height - this.refY;
                break;
            }
            case 2: {
                curRefX = width - this.refX;
                curRefY = this.refY;
                break;
            }
            case 3: {
                curRefX = this.refX;
                curRefY = height - this.refY;
                break;
            }
            case 4: {
                curRefX = height - this.refY;
                curRefY = this.refX;
                break;
            }
            case 5: {
                curRefX = height - this.refY;
                curRefY = width - this.refX;
                break;
            }
            case 6: {
                curRefX = this.refY;
                curRefY = this.refX;
                break;
            }
            case 7: {
                curRefX = this.refY;
                curRefY = width - this.refX;
                break;
            }
            default: {
                return;
            }
        }
        this.move(curRefX - newRefX, curRefY - newRefY);
        this.transform = transform;
    }

    private synchronized boolean collidesWith(Object o2, int oX, int oY) {
        int tX = 0;
        int tY = 0;
        int tW = 0;
        int tH = 0;
        int oW = 0;
        int oH = 0;
        Sprite t2 = this;
        boolean another = true;
        while (another) {
            int sH;
            int sW;
            int sY;
            int sX;
            int cX = t2.collX;
            int cY = t2.collY;
            int cW = t2.collWidth;
            int cH = t2.collHeight;
            if (cW == 0 || cH == 0) {
                return false;
            }
            switch (t2.transform) {
                case 0: {
                    sX = t2.getX() + cX;
                    sY = t2.getY() + cY;
                    sW = cW;
                    sH = cH;
                    break;
                }
                case 1: {
                    sX = t2.getX() + cX;
                    sY = t2.getY() + (t2.getHeight() - cY - 1) - cH;
                    sW = cW;
                    sH = cH;
                    break;
                }
                case 2: {
                    sX = t2.getX() + (t2.getWidth() - cX - 1) - cW;
                    sY = t2.getY() + cY;
                    sW = cW;
                    sH = cH;
                    break;
                }
                case 3: {
                    sX = t2.getX() + (t2.getWidth() - cX - 1) - cW;
                    sY = t2.getY() + (t2.getHeight() - cY - 1) - cH;
                    sW = cW;
                    sH = cH;
                    break;
                }
                case 4: {
                    sX = t2.getX() + cY;
                    sY = t2.getY() + cX;
                    sW = cH;
                    sH = cW;
                    break;
                }
                case 5: {
                    sX = t2.getX() + (t2.getHeight() - cY - 1) - cH;
                    sY = t2.getY() + cX;
                    sW = cH;
                    sH = cW;
                    break;
                }
                case 7: {
                    sX = t2.getX() + (t2.getHeight() - cY - 1) - cH;
                    sY = t2.getY() + (t2.getWidth() - cX - 1) - cW;
                    sW = cH;
                    sH = cW;
                    break;
                }
                case 6: {
                    sX = t2.getX() + cY;
                    sY = t2.getY() + (t2.getWidth() - cX - 1) - cW;
                    sW = cH;
                    sH = cW;
                    break;
                }
                default: {
                    return false;
                }
            }
            if (o2 != t2) {
                tX = sX;
                tY = sY;
                tW = sW;
                tH = sH;
                if (o2 instanceof Sprite) {
                    t2 = (Sprite)o2;
                    continue;
                }
                if (o2 instanceof TiledLayer) {
                    another = false;
                    TiledLayer layer = (TiledLayer)o2;
                    oX = layer.getX();
                    oY = layer.getY();
                    oW = layer.getWidth();
                    oH = layer.getHeight();
                    continue;
                }
                another = false;
                Image img = (Image)o2;
                oW = img.getWidth();
                oH = img.getHeight();
                continue;
            }
            another = false;
            oX = sX;
            oY = sY;
            oW = sW;
            oH = sH;
        }
        if (tX > oX && tX >= oX + oW) {
            return false;
        }
        if (tX < oX && tX + tW <= oX) {
            return false;
        }
        if (tY > oY && tY >= oY + oH) {
            return false;
        }
        if (tY < oY && tY + tH <= oY) {
            return false;
        }
        if (o2 instanceof TiledLayer) {
            int rH;
            int rY;
            int rW;
            int rX;
            TiledLayer layer = (TiledLayer)o2;
            if (oX > tX) {
                rX = oX;
                rW = (oX + oW < tX + tW ? oX + oW : tX + tW) - rX;
            } else {
                rX = tX;
                rW = (tX + tW < oX + oW ? tX + tW : oX + oW) - rX;
            }
            if (oY > tY) {
                rY = oY;
                rH = (oY + oH < tY + tH ? oY + oH : tY + tH) - rY;
            } else {
                rY = tY;
                rH = (tY + tH < oY + oH ? tY + tH : oY + oH) - rY;
            }
            Image img = layer.img;
            int lW = layer.getCellWidth();
            int lH = layer.getCellHeight();
            int minC = (rX - oX) / lW;
            int minR = (rY - oY) / lH;
            int maxC = (rX - oX + rW - 1) / lW;
            int maxR = (rY - oY + rH - 1) / lH;
            int row = minR;
            while (row <= maxR) {
                int col = minC;
                while (col <= maxC) {
                    int cell = layer.getCell(col, row);
                    if (cell < 0) {
                        cell = layer.getAnimatedTile(cell);
                    }
                    if (cell != 0) {
                        return true;
                    }
                    ++col;
                }
                ++row;
            }
            return false;
        }
        return true;
    }

    private synchronized boolean collidesWithPixelLevel(Object o2, int oX, int oY) {
        int rH;
        int rY;
        int rW;
        int rX;
        boolean another = true;
        Sprite t2 = this;
        int tX = 0;
        int tY = 0;
        int tW = 0;
        int tH = 0;
        int oW = 0;
        int oH = 0;
        while (another) {
            int sH;
            int sW;
            int sY;
            int sX;
            if (t2.collX >= t2.getWidth() || t2.collX + t2.collWidth <= 0 || t2.collY >= t2.getHeight() || t2.collY + t2.collHeight <= 0) {
                return false;
            }
            int cX = t2.collX >= 0 ? t2.collX : 0;
            int cY = t2.collY >= 0 ? t2.collY : 0;
            int cW = t2.collX + t2.collWidth < t2.getWidth() ? t2.collX + t2.collWidth - cX : t2.getWidth() - cX;
            int cH = t2.collY + t2.collHeight < t2.getHeight() ? t2.collY + t2.collHeight - cY : t2.getHeight() - cY;
            switch (t2.transform) {
                case 0: {
                    sX = t2.getX() + cX;
                    sY = t2.getY() + cY;
                    sW = cW;
                    sH = cH;
                    break;
                }
                case 1: {
                    sX = t2.getX() + cX;
                    sY = t2.getY() + (t2.getHeight() - cY - 1) - cH;
                    sW = cW;
                    sH = cH;
                    break;
                }
                case 2: {
                    sX = t2.getX() + (t2.getWidth() - cX - 1) - cW;
                    sY = t2.getY() + cY;
                    sW = cW;
                    sH = cH;
                    break;
                }
                case 3: {
                    sX = t2.getX() + (t2.getWidth() - cX - 1) - cW;
                    sY = t2.getY() + (t2.getHeight() - cY - 1) - cH;
                    sW = cW;
                    sH = cH;
                    break;
                }
                case 4: {
                    sX = t2.getX() + cY;
                    sY = t2.getY() + cX;
                    sW = cH;
                    sH = cW;
                    break;
                }
                case 5: {
                    sX = t2.getX() + (t2.getHeight() - cY) - cH;
                    sY = t2.getY() + cX;
                    sW = cH;
                    sH = cW;
                    break;
                }
                case 7: {
                    sX = t2.getX() + (t2.getHeight() - cY) - cH;
                    sY = t2.getY() + (t2.getWidth() - cX) - cW;
                    sW = cH;
                    sH = cW;
                    break;
                }
                case 6: {
                    sX = t2.getX() + cY;
                    sY = t2.getY() + (t2.getWidth() - cX) - cW;
                    sW = cH;
                    sH = cW;
                    break;
                }
                default: {
                    return false;
                }
            }
            if (o2 != t2) {
                tX = sX;
                tY = sY;
                tW = sW;
                tH = sH;
                if (o2 instanceof Sprite) {
                    t2 = (Sprite)o2;
                    continue;
                }
                if (o2 instanceof TiledLayer) {
                    another = false;
                    TiledLayer layer = (TiledLayer)o2;
                    oX = layer.getX();
                    oY = layer.getY();
                    oW = layer.getWidth();
                    oH = layer.getHeight();
                    continue;
                }
                another = false;
                Image img = (Image)o2;
                oW = img.getWidth();
                oH = img.getHeight();
                continue;
            }
            another = false;
            oX = sX;
            oY = sY;
            oW = sW;
            oH = sH;
        }
        if (tX > oX && tX >= oX + oW) {
            return false;
        }
        if (tX < oX && tX + tW <= oX) {
            return false;
        }
        if (tY > oY && tY >= oY + oH) {
            return false;
        }
        if (tY < oY && tY + tH <= oY) {
            return false;
        }
        if (oX > tX) {
            rX = oX;
            rW = (oX + oW < tX + tW ? oX + oW : tX + tW) - rX;
        } else {
            rX = tX;
            rW = (tX + tW < oX + oW ? tX + tW : oX + oW) - rX;
        }
        if (oY > tY) {
            rY = oY;
            rH = (oY + oH < tY + tH ? oY + oH : tY + tH) - rY;
        } else {
            rY = tY;
            rH = (tY + tH < oY + oH ? tY + tH : oY + oH) - rY;
        }
        int tColIncr = 0;
        int tRowIncr = 0;
        int tOffset = 0;
        int oColIncr = 0;
        int oRowIncr = 0;
        int oOffset = 0;
        int f2 = this.sequence == null ? this.frame : this.sequence[this.frame];
        int fW = this.getWidth();
        int fH = this.getHeight();
        int fX = fW * (f2 % this.rows);
        int fY = fH * (f2 / this.rows);
        if (this.rgbData == null) {
            this.rgbData = new int[fW * fH];
            this.rgbDataAux = new int[fW * fH];
        }
        t2 = this;
        another = true;
        int[] tRgbData = this.rgbData;
        while (another) {
            int sRowIncr;
            int sColIncr;
            int sOffset;
            switch (t2.transform) {
                case 0: {
                    t2.img.getRGB(tRgbData, 0, rW, fX + rX - t2.getX(), fY + rY - t2.getY(), rW, rH);
                    sOffset = 0;
                    sColIncr = 1;
                    sRowIncr = 0;
                    break;
                }
                case 3: {
                    t2.img.getRGB(tRgbData, 0, rW, fX + fW - (rX - t2.getX()) - rW - 1, fY + fH - (rY - t2.getY()) - rH - 1, rW, rH);
                    sOffset = rH * rW - 1;
                    sColIncr = -1;
                    sRowIncr = 0;
                    break;
                }
                case 2: {
                    t2.img.getRGB(tRgbData, 0, rW, fX + fW - (rX - t2.getX()) - rW - 1, fY + rY - t2.getY(), rW, rH);
                    sOffset = rW - 1;
                    sColIncr = -1;
                    sRowIncr = rW << 1;
                    break;
                }
                case 1: {
                    t2.img.getRGB(tRgbData, 0, rW, fX + rX - t2.getX(), fY + fH - (rY - t2.getY()) - rH - 1, rW, rH);
                    sOffset = (rH - 1) * rW;
                    sColIncr = 1;
                    sRowIncr = -(rW << 1);
                    break;
                }
                case 5: {
                    t2.img.getRGB(tRgbData, 0, rH, fX + rY - t2.getY(), fY + fH - (rX - t2.getX()) - rW, rH, rW);
                    sOffset = (rW - 1) * rH;
                    sColIncr = -rH;
                    sRowIncr = rH * rW + 1;
                    break;
                }
                case 7: {
                    t2.img.getRGB(tRgbData, 0, rH, fX + fW - (rY - t2.getY()) - rH, fY + fH - (rX - t2.getX()) - rW, rH, rW);
                    sOffset = rH * rW - 1;
                    sColIncr = -rH;
                    sRowIncr = rH * rW - 1;
                    break;
                }
                case 4: {
                    t2.img.getRGB(tRgbData, 0, rH, fX + rY - t2.getY(), fY + rX - t2.getX(), rH, rW);
                    sOffset = 0;
                    sColIncr = rH;
                    sRowIncr = -(rH * rW) + 1;
                    break;
                }
                case 6: {
                    t2.img.getRGB(tRgbData, 0, rH, fX + fW - (rY - t2.getY()) - rH, fY + rX - t2.getX(), rH, rW);
                    sOffset = rH - 1;
                    sColIncr = rH;
                    sRowIncr = -(rH * rW) - 1;
                    break;
                }
                default: {
                    return false;
                }
            }
            if (o2 != t2) {
                tOffset = sOffset;
                tRowIncr = sRowIncr;
                tColIncr = sColIncr;
                if (o2 instanceof Sprite) {
                    t2 = (Sprite)o2;
                    tRgbData = this.rgbDataAux;
                    f2 = t2.sequence == null ? t2.frame : t2.sequence[t2.frame];
                    fW = t2.getWidth();
                    fH = t2.getHeight();
                    fX = fW * (f2 % t2.rows);
                    fY = fH * (f2 / t2.rows);
                    continue;
                }
                if (o2 instanceof TiledLayer) {
                    another = false;
                    TiledLayer layer = (TiledLayer)o2;
                    Image img = layer.img;
                    oOffset = 0;
                    oColIncr = 1;
                    oRowIncr = 0;
                    int lW = layer.getCellWidth();
                    int lH = layer.getCellHeight();
                    int minC = (rX - oX) / lW;
                    int minR = (rY - oY) / lH;
                    int maxC = (rX - oX + rW - 1) / lW;
                    int maxR = (rY - oY + rH - 1) / lH;
                    int row = minR;
                    while (row <= maxR) {
                        int col = minC;
                        while (col <= maxC) {
                            int cell = layer.getCell(col, row);
                            if (cell < 0) {
                                cell = layer.getAnimatedTile(cell);
                            }
                            int minX = col == minC ? (rX - oX) % lW : 0;
                            int minY = row == minR ? (rY - oY) % lH : 0;
                            int maxX = col == maxC ? (rX + rW - oX - 1) % lW : lW - 1;
                            int maxY = row == maxR ? (rY + rH - oY - 1) % lH : lH - 1;
                            int c2 = (row - minR) * lH * rW + (col - minC) * lW - (col == minC ? 0 : (rX - oX) % lW) - (row == minR ? 0 : (rY - oY) % lH) * rW;
                            if (cell == 0) {
                                int y2 = minY;
                                while (y2 <= maxY) {
                                    int x2 = minX;
                                    while (x2 <= maxX) {
                                        this.rgbDataAux[c2] = 0;
                                        ++x2;
                                        ++c2;
                                    }
                                    ++y2;
                                    c2 += rW - (maxX - minX + 1);
                                }
                            } else {
                                int imgCols = img.getWidth() / layer.getCellWidth();
                                int xSrc = lW * (--cell % imgCols);
                                int ySrc = cell / imgCols * lH;
                                img.getRGB(this.rgbDataAux, c2, rW, xSrc + minX, ySrc + minY, maxX - minX + 1, maxY - minY + 1);
                            }
                            ++col;
                        }
                        ++row;
                    }
                    continue;
                }
                another = false;
                Image img = (Image)o2;
                img.getRGB(this.rgbDataAux, 0, rW, rX - oX, rY - oY, rW, rH);
                oOffset = 0;
                oColIncr = 1;
                oRowIncr = 0;
                continue;
            }
            another = false;
            oOffset = sOffset;
            oRowIncr = sRowIncr;
            oColIncr = sColIncr;
        }
        int row = 0;
        while (row < rH) {
            int col = 0;
            while (col < rW) {
                int rgb = this.rgbData[tOffset];
                int rgbA = this.rgbDataAux[oOffset];
                if ((rgb & rgbA) >> 24 == -1) {
                    return true;
                }
                ++col;
                tOffset += tColIncr;
                oOffset += oColIncr;
            }
            ++row;
            tOffset += tRowIncr;
            oOffset += oRowIncr;
        }
        return false;
    }
}

