/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import org.microemu.device.DeviceFactory;

class StringComponent {
    private String text;
    private int[] breaks = new int[4];
    private boolean invertPaint = false;
    private int numOfBreaks;
    private int width;
    private int widthDecreaser;

    public StringComponent() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringComponent(String text) {
        StringComponent stringComponent = this;
        synchronized (stringComponent) {
            this.width = -1;
            this.widthDecreaser = 0;
            this.setText(text);
        }
    }

    public int getCharHeight() {
        return Font.getDefaultFont().getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCharPositionX(int num) {
        StringComponent stringComponent = this;
        synchronized (stringComponent) {
            if (this.numOfBreaks == -1) {
                this.updateBreaks();
            }
            int prevIndex = 0;
            Font f2 = Font.getDefaultFont();
            int i2 = 0;
            while (i2 < this.numOfBreaks) {
                if (num < this.breaks[i2]) break;
                prevIndex = this.breaks[i2];
                ++i2;
            }
            return f2.substringWidth(this.text, prevIndex, num - prevIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCharPositionY(int num) {
        int y2 = 0;
        StringComponent stringComponent = this;
        synchronized (stringComponent) {
            if (this.numOfBreaks == -1) {
                this.updateBreaks();
            }
            Font f2 = Font.getDefaultFont();
            int i2 = 0;
            while (i2 < this.numOfBreaks) {
                if (num < this.breaks[i2]) break;
                y2 += f2.getHeight();
                ++i2;
            }
        }
        return y2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHeight() {
        int height;
        StringComponent stringComponent = this;
        synchronized (stringComponent) {
            Font f2;
            block7: {
                if (this.numOfBreaks == -1) {
                    this.updateBreaks();
                }
                f2 = Font.getDefaultFont();
                if (this.text != null) break block7;
                return 0;
            }
            if (this.numOfBreaks == 0) {
                return f2.getHeight();
            }
            height = this.numOfBreaks * f2.getHeight();
            if (this.breaks[this.numOfBreaks - 1] != this.text.length() - 1 || this.text.charAt(this.text.length() - 1) != '\n') {
                height += f2.getHeight();
            }
        }
        return height;
    }

    public String getText() {
        return this.text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invertPaint(boolean state) {
        StringComponent stringComponent = this;
        synchronized (stringComponent) {
            this.invertPaint = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int paint(Graphics g2) {
        int y2;
        if (this.text == null) {
            return 0;
        }
        StringComponent stringComponent = this;
        synchronized (stringComponent) {
            if (this.numOfBreaks == -1) {
                this.updateBreaks();
            }
            Font f2 = Font.getDefaultFont();
            y2 = 0;
            int prevIndex = 0;
            int i2 = 0;
            while (i2 < this.numOfBreaks) {
                if (this.invertPaint) {
                    g2.setGrayScale(0);
                } else {
                    g2.setGrayScale(255);
                }
                g2.fillRect(0, y2, this.width, f2.getHeight());
                if (this.invertPaint) {
                    g2.setGrayScale(255);
                } else {
                    g2.setGrayScale(0);
                }
                g2.drawSubstring(this.text, prevIndex, this.breaks[i2] - prevIndex, 0, y2, 0);
                prevIndex = this.breaks[i2];
                y2 += f2.getHeight();
                ++i2;
            }
            if (prevIndex != this.text.length() || this.text.length() == 0) {
                if (this.invertPaint) {
                    g2.setGrayScale(0);
                } else {
                    g2.setGrayScale(255);
                }
                g2.fillRect(0, y2, this.width, f2.getHeight());
                if (this.invertPaint) {
                    g2.setGrayScale(255);
                } else {
                    g2.setGrayScale(0);
                }
                g2.drawSubstring(this.text, prevIndex, this.text.length() - prevIndex, 0, y2, 0);
                y2 += f2.getHeight();
            }
        }
        return y2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String text) {
        StringComponent stringComponent = this;
        synchronized (stringComponent) {
            this.text = text;
            this.numOfBreaks = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWidthDecreaser(int widthDecreaser) {
        StringComponent stringComponent = this;
        synchronized (stringComponent) {
            this.widthDecreaser = widthDecreaser;
            this.numOfBreaks = -1;
        }
    }

    private void insertBreak(int pos) {
        int i2 = 0;
        while (i2 < this.numOfBreaks) {
            if (pos < this.breaks[i2]) break;
            ++i2;
        }
        if (this.numOfBreaks + 1 == this.breaks.length) {
            int[] newbreaks = new int[this.breaks.length + 4];
            System.arraycopy(this.breaks, 0, newbreaks, 0, this.numOfBreaks);
            this.breaks = newbreaks;
        }
        System.arraycopy(this.breaks, i2, this.breaks, i2 + 1, this.numOfBreaks - i2);
        this.breaks[i2] = pos;
        ++this.numOfBreaks;
    }

    private void updateBreaks() {
        if (this.text == null) {
            return;
        }
        this.width = DeviceFactory.getDevice().getDeviceDisplay().getWidth() - this.widthDecreaser;
        int prevIndex = 0;
        int canBreak = 0;
        this.numOfBreaks = 0;
        Font f2 = Font.getDefaultFont();
        int i2 = 0;
        while (i2 < this.text.length()) {
            if (this.text.charAt(i2) == ' ') {
                canBreak = i2 + 1;
            }
            if (this.text.charAt(i2) == '\n') {
                this.insertBreak(i2);
                canBreak = 0;
                prevIndex = i2 + 1;
            } else if (f2.substringWidth(this.text, prevIndex, i2 - prevIndex + 1) > this.width) {
                if (canBreak != 0) {
                    this.insertBreak(canBreak);
                    prevIndex = i2 = canBreak;
                } else {
                    this.insertBreak(i2);
                    prevIndex = i2 + 1;
                }
                canBreak = 0;
            }
            ++i2;
        }
    }
}

