/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.StringComponent;
import javax.microedition.lcdui.Ticker;
import org.microemu.device.Device;
import org.microemu.device.DeviceFactory;
import org.microemu.device.ui.CommandUI;
import org.microemu.device.ui.DisplayableUI;

public abstract class Displayable {
    Device device = DeviceFactory.getDevice();
    Display currentDisplay = null;
    int width = -1;
    int height = -1;
    boolean fullScreenMode = false;
    Ticker ticker;
    int viewPortY;
    int viewPortHeight;
    DisplayableUI ui;
    private String title;
    private CommandListener listener = null;

    Displayable(String title) {
        this.title = title;
    }

    void setUI(DisplayableUI ui) {
        this.ui = ui;
    }

    public void addCommand(Command cmd) {
        this.ui.addCommandUI(cmd.ui);
    }

    public void removeCommand(Command cmd) {
        this.ui.removeCommandUI(cmd.ui);
    }

    public int getWidth() {
        if (this.width == -1) {
            this.width = this.fullScreenMode ? this.device.getDeviceDisplay().getFullWidth() : this.device.getDeviceDisplay().getWidth();
        }
        return this.width;
    }

    public int getHeight() {
        if (this.height == -1) {
            this.height = this.fullScreenMode ? this.device.getDeviceDisplay().getFullHeight() : this.device.getDeviceDisplay().getHeight();
        }
        return this.height;
    }

    public boolean isShown() {
        if (this.currentDisplay == null) {
            return false;
        }
        return this.currentDisplay.isShown(this);
    }

    public Ticker getTicker() {
        return this.ticker;
    }

    public void setTicker(Ticker ticker) {
        this.ticker = ticker;
        this.repaint();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String s2) {
        this.title = s2;
        this.ui.invalidate();
    }

    public void setCommandListener(CommandListener l2) {
        this.listener = l2;
        this.ui.setCommandListener(l2);
    }

    CommandListener getCommandListener() {
        return this.listener;
    }

    Vector getCommands() {
        Vector<Command> result = new Vector<Command>();
        Vector commandsUI = this.ui.getCommandsUI();
        int i2 = 0;
        while (i2 < commandsUI.size()) {
            result.addElement(((CommandUI)commandsUI.elementAt(i2)).getCommand());
            ++i2;
        }
        return result;
    }

    void hideNotify() {
    }

    final void hideNotify(Display d2) {
        this.ui.hideNotify();
        this.hideNotify();
    }

    void keyPressed(int keyCode) {
    }

    void keyRepeated(int keyCode) {
    }

    void keyReleased(int keyCode) {
    }

    void pointerPressed(int x2, int y2) {
    }

    void pointerReleased(int x2, int y2) {
    }

    void pointerDragged(int x2, int y2) {
    }

    abstract void paint(Graphics var1);

    void repaint() {
        if (this.currentDisplay != null) {
            this.repaint(0, 0, this.getWidth(), this.getHeight());
        }
    }

    void repaint(int x2, int y2, int width, int height) {
        if (this.currentDisplay != null) {
            this.currentDisplay.repaint(this, x2, y2, width, height);
        }
    }

    protected void sizeChanged(int w2, int h2) {
    }

    final void sizeChanged(Display d2) {
        this.width = -1;
        this.height = -1;
        this.fullScreenMode = true;
        this.sizeChanged(this.getWidth(), this.getHeight());
    }

    void showNotify() {
    }

    final void showNotify(Display d2) {
        this.currentDisplay = d2;
        this.viewPortY = 0;
        StringComponent title = new StringComponent(this.getTitle());
        this.viewPortHeight = this.getHeight() - title.getHeight() - 1;
        if (this.ticker != null) {
            this.viewPortHeight -= this.ticker.getHeight();
        }
        int w2 = this.fullScreenMode ? this.device.getDeviceDisplay().getFullWidth() : this.device.getDeviceDisplay().getWidth();
        int h2 = this.fullScreenMode ? this.device.getDeviceDisplay().getFullHeight() : this.device.getDeviceDisplay().getHeight();
        if (this.width != w2 || this.height != h2) {
            this.sizeChanged(d2);
        }
        this.showNotify();
        this.ui.showNotify();
    }
}

