/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.util.Calendar;
import java.util.Date;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

class DateCanvas
extends Canvas {
    Calendar cal = Calendar.getInstance();
    private int month;
    private int day;
    private int year;
    private int selected;

    public Date getTime() {
        this.cal.set(1, this.year);
        this.cal.set(2, this.month);
        this.cal.set(5, this.day);
        return this.cal.getTime();
    }

    public void setTime(Date time) {
        this.cal.setTime(time);
        this.year = this.cal.get(1);
        this.month = this.cal.get(2);
        this.day = this.cal.get(5);
        this.repaint();
    }

    @Override
    public void paint(Graphics g2) {
        int colorT;
        int colorR;
        int offset;
        int w2 = this.getWidth();
        int h2 = this.getHeight();
        g2.setColor(0xFFFFFF);
        g2.fillRect(0, 0, w2, h2);
        Font font = Font.getFont(32, 1, 0);
        String dayStr = Integer.toString(this.day);
        if (this.day < 10) {
            dayStr = "0" + dayStr;
        }
        String monthStr = Integer.toString(this.month + 1);
        if (this.month + 1 < 10) {
            monthStr = "0" + monthStr;
        }
        String yearStr = Integer.toString(this.year);
        String delimiterStr = "/";
        int y2 = h2 - font.getHeight() >>> 1;
        int dayW = font.stringWidth(dayStr);
        int monthW = font.stringWidth(monthStr);
        int yearW = font.stringWidth(yearStr);
        int delimiterW = font.stringWidth(delimiterStr);
        int stringWidth = dayW + monthW + yearW + (delimiterW << 1);
        int dOff = offset = w2 - stringWidth >>> 1;
        int del1Off = dOff + dayW;
        int mOff = del1Off + delimiterW;
        int del2Off = mOff + monthW;
        int yOff = del2Off + delimiterW;
        g2.setColor(0);
        g2.setFont(font);
        g2.drawString(delimiterStr, del1Off, y2, 20);
        g2.drawString(delimiterStr, del2Off, y2, 20);
        if (this.selected == 0) {
            colorR = 0;
            colorT = 0xFFFFFF;
        } else {
            colorR = 0xFFFFFF;
            colorT = 0;
        }
        g2.setColor(colorR);
        g2.fillRect(dOff, y2, dayW, font.getHeight());
        g2.setColor(colorT);
        g2.drawString(dayStr, dOff, y2, 20);
        if (this.selected == 1) {
            colorR = 0;
            colorT = 0xFFFFFF;
        } else {
            colorR = 0xFFFFFF;
            colorT = 0;
        }
        g2.setColor(colorR);
        g2.fillRect(mOff, y2, monthW, font.getHeight());
        g2.setColor(colorT);
        g2.drawString(monthStr, mOff, y2, 20);
        if (this.selected == 2) {
            colorR = 0;
            colorT = 0xFFFFFF;
        } else {
            colorR = 0xFFFFFF;
            colorT = 0;
        }
        g2.setColor(colorR);
        g2.fillRect(yOff, y2, yearW, font.getHeight());
        g2.setColor(colorT);
        g2.drawString(yearStr, yOff, y2, 20);
    }

    @Override
    public synchronized void keyPressed(int keycode) {
        int k2 = this.getGameAction(keycode);
        if (k2 == 2 && this.selected > 0) {
            --this.selected;
            this.repaint();
        } else if (k2 == 5 && this.selected < 2) {
            ++this.selected;
            this.repaint();
        } else if (k2 == 1) {
            Calendar cal = Calendar.getInstance();
            switch (this.selected) {
                case 0: {
                    cal.set(1, this.year);
                    cal.set(2, this.month);
                    cal.set(5, this.day);
                    cal.set(11, 1);
                    cal.setTime(cal.getTime());
                    cal.add(5, 1);
                    if (cal.get(2) == this.month) {
                        ++this.day;
                        break;
                    }
                    this.day = 1;
                    break;
                }
                case 1: {
                    this.month = this.month == 11 ? 0 : ++this.month;
                    cal.set(1, this.year);
                    cal.set(2, this.month);
                    cal.set(5, 28);
                    cal.set(11, 1);
                    cal.setTime(cal.getTime());
                    cal.add(5, 4);
                    int daysInMonth = 28 + (4 - cal.get(5));
                    if (this.day <= daysInMonth) break;
                    this.day = daysInMonth;
                    break;
                }
                case 2: {
                    if (this.year >= 5000) break;
                    ++this.year;
                    if (this.day != 29 || this.month != 1) break;
                    this.day = 28;
                }
            }
            this.repaint();
        } else if (k2 == 6) {
            Calendar cal = Calendar.getInstance();
            switch (this.selected) {
                case 0: {
                    int daysInMonth;
                    if (this.day > 1) {
                        --this.day;
                        break;
                    }
                    cal.set(1, this.year);
                    cal.set(2, this.month);
                    cal.set(5, 28);
                    cal.set(11, 1);
                    cal.setTime(cal.getTime());
                    cal.add(5, 4);
                    this.day = daysInMonth = 28 + (4 - cal.get(5));
                    break;
                }
                case 1: {
                    this.month = this.month == 0 ? 11 : --this.month;
                    cal.set(1, this.year);
                    cal.set(2, this.month);
                    cal.set(5, 28);
                    cal.set(11, 1);
                    cal.setTime(cal.getTime());
                    cal.add(5, 1);
                    int daysInMonth = 28 + (4 - cal.get(5));
                    if (this.day <= daysInMonth) break;
                    this.day = daysInMonth;
                    break;
                }
                case 2: {
                    if (this.year <= 1000) break;
                    --this.year;
                    if (this.day != 29 || this.month != 1) break;
                    this.day = 28;
                }
            }
            this.repaint();
        }
    }
}

